/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.unorderedreceiver;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Iterator;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.MetricDef;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.ops.OperatorStats;
import org.apache.drill.exec.physical.config.UnorderedReceiver;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RawFragmentBatch;
import org.apache.drill.exec.record.RawFragmentBatchProvider;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnorderedReceiverBatch
implements RecordBatch {
    static final Logger logger = LoggerFactory.getLogger(UnorderedReceiverBatch.class);
    private RecordBatchLoader batchLoader;
    private RawFragmentBatchProvider fragProvider;
    private FragmentContext context;
    private BatchSchema schema;
    private OperatorStats stats;
    private boolean first;
    private UnorderedReceiver config;
    OperatorContext oContext;

    @Override
    public FragmentContext getContext() {
        return this.context;
    }

    @Override
    public BatchSchema getSchema() {
        return this.schema;
    }

    @Override
    public int getRecordCount() {
        return this.batchLoader.getRecordCount();
    }

    @Override
    public void kill(boolean sendUpstream) {
        if (sendUpstream) {
            this.informSenders();
        }
        this.fragProvider.kill(this.context);
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.batchLoader.iterator();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        return this.batchLoader.getValueVectorId(path);
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... ids) {
        return this.batchLoader.getValueAccessorById(clazz, ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordBatch.IterOutcome next() {
        this.stats.startProcessing();
        try {
            RawFragmentBatch batch;
            try {
                this.stats.startWait();
                batch = this.fragProvider.getNext();
                while (!(batch == null || batch.getHeader().getIsOutOfMemory() || batch.getHeader().getDef().getRecordCount() != 0 || this.first && batch.getHeader().getDef().getFieldCount() != 0)) {
                    batch = this.fragProvider.getNext();
                }
            }
            finally {
                this.stats.stopWait();
            }
            this.first = false;
            if (batch == null) {
                this.batchLoader.clear();
                if (this.context.isCancelled()) {
                    RecordBatch.IterOutcome iterOutcome = RecordBatch.IterOutcome.STOP;
                    return iterOutcome;
                }
                RecordBatch.IterOutcome iterOutcome = RecordBatch.IterOutcome.NONE;
                return iterOutcome;
            }
            if (batch.getHeader().getIsOutOfMemory()) {
                RecordBatch.IterOutcome iterOutcome = RecordBatch.IterOutcome.OUT_OF_MEMORY;
                return iterOutcome;
            }
            UserBitShared.RecordBatchDef rbd = batch.getHeader().getDef();
            boolean schemaChanged = this.batchLoader.load(rbd, batch.getBody());
            this.stats.addLongStat(Metric.BYTES_RECEIVED, batch.getByteCount());
            batch.release();
            if (schemaChanged) {
                this.schema = this.batchLoader.getSchema();
                this.stats.batchReceived(0, rbd.getRecordCount(), true);
                RecordBatch.IterOutcome iterOutcome = RecordBatch.IterOutcome.OK_NEW_SCHEMA;
                return iterOutcome;
            }
            this.stats.batchReceived(0, rbd.getRecordCount(), false);
            RecordBatch.IterOutcome iterOutcome = RecordBatch.IterOutcome.OK;
            return iterOutcome;
        }
        catch (IOException | SchemaChangeException ex) {
            this.context.fail(ex);
            RecordBatch.IterOutcome iterOutcome = RecordBatch.IterOutcome.STOP;
            return iterOutcome;
        }
        finally {
            this.stats.stopProcessing();
        }
    }

    @Override
    public WritableBatch getWritableBatch() {
        return this.batchLoader.getWritableBatch();
    }

    @Override
    public void cleanup() {
        this.batchLoader.clear();
        this.fragProvider.cleanup();
        this.oContext.close();
    }

    private void informSenders() {
        ExecProtos.FragmentHandle handlePrototype = ExecProtos.FragmentHandle.newBuilder().setMajorFragmentId(this.config.getOppositeMajorFragmentId()).setQueryId(this.context.getHandle().getQueryId()).build();
        for (int i = 0; i < this.config.getNumSenders(); ++i) {
            ExecProtos.FragmentHandle sender = ExecProtos.FragmentHandle.newBuilder(handlePrototype).setMinorFragmentId(i).build();
            BitControl.FinishedReceiver finishedReceiver = BitControl.FinishedReceiver.newBuilder().setReceiver(this.context.getHandle()).setSender(sender).build();
            this.context.getControlTunnel(this.config.getProvidingEndpoints().get(i)).informReceiverFinished(new OutcomeListener(), finishedReceiver);
        }
    }

    private class OutcomeListener
    implements RpcOutcomeListener<GeneralRPCProtos.Ack> {
        private OutcomeListener() {
        }

        @Override
        public void failed(RpcException ex) {
            logger.warn("Failed to inform upstream that receiver is finished");
        }

        @Override
        public void success(GeneralRPCProtos.Ack value, ByteBuf buffer) {
        }
    }

    public static enum Metric implements MetricDef
    {
        BYTES_RECEIVED,
        NUM_SENDERS;


        @Override
        public int metricId() {
            return this.ordinal();
        }
    }
}

