/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.sort;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.vector.ValueVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordBatchData {
    static final Logger logger = LoggerFactory.getLogger(RecordBatchData.class);
    private SelectionVector2 sv2;
    private int recordCount;
    VectorContainer container = new VectorContainer();

    public RecordBatchData(VectorAccessible batch) {
        ArrayList<ValueVector> vectors = Lists.newArrayList();
        this.recordCount = batch.getRecordCount();
        this.sv2 = batch instanceof RecordBatch && batch.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE ? ((RecordBatch)batch).getSelectionVector2().clone() : null;
        for (VectorWrapper v : batch) {
            if (v.isHyper()) {
                throw new UnsupportedOperationException("Record batch data can't be created based on a hyper batch.");
            }
            TransferPair tp = v.getValueVector().getTransferPair();
            tp.transfer();
            vectors.add(tp.getTo());
        }
        this.container.addCollection(vectors);
        this.container.setRecordCount(this.recordCount);
        this.container.buildSchema(batch.getSchema().getSelectionVectorMode());
    }

    public VectorContainer getContainer() {
        return this.container;
    }
}

