/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.project;

import com.carrotsearch.hppc.IntOpenHashSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sun.codemodel.JExpr;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.FunctionCallFactory;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.expression.fn.CastFunctions;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.DrillFuncHolderExpr;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.ValueVectorReadExpression;
import org.apache.drill.exec.expr.ValueVectorWriteExpression;
import org.apache.drill.exec.expr.fn.DrillComplexWriterFuncHolder;
import org.apache.drill.exec.physical.config.Project;
import org.apache.drill.exec.physical.impl.project.Projector;
import org.apache.drill.exec.record.AbstractSingleRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TransferPair;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.writer.BaseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectRecordBatch
extends AbstractSingleRecordBatch<Project> {
    static final Logger logger = LoggerFactory.getLogger(ProjectRecordBatch.class);
    private Projector projector;
    private List<ValueVector> allocationVectors;
    private List<BaseWriter.ComplexWriter> complexWriters;
    private boolean hasRemainder;
    private int remainderIndex;
    private int recordCount;
    private boolean first;

    @Override
    public int getRecordCount() {
        return this.recordCount;
    }

    @Override
    protected void killIncoming(boolean sendUpstream) {
        super.killIncoming(sendUpstream);
        this.hasRemainder = false;
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        if (this.hasRemainder) {
            this.handleRemainder();
            return RecordBatch.IterOutcome.OK;
        }
        return super.innerNext();
    }

    @Override
    protected RecordBatch.IterOutcome doWork() {
        int incomingRecordCount = this.incoming.getRecordCount();
        if (this.first && incomingRecordCount == 0 && this.complexWriters != null) {
            RecordBatch.IterOutcome next = null;
            while (incomingRecordCount == 0) {
                next = this.next(this.incoming);
                if (next != RecordBatch.IterOutcome.OK && next != RecordBatch.IterOutcome.OK_NEW_SCHEMA) {
                    return next;
                }
                incomingRecordCount = this.incoming.getRecordCount();
            }
            if (next == RecordBatch.IterOutcome.OK_NEW_SCHEMA) {
                try {
                    this.setupNewSchema();
                }
                catch (SchemaChangeException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.first = false;
        this.container.zeroVectors();
        if (!this.doAlloc()) {
            this.outOfMemory = true;
            return RecordBatch.IterOutcome.OUT_OF_MEMORY;
        }
        int outputRecords = this.projector.projectRecords(0, incomingRecordCount, 0);
        if (outputRecords < incomingRecordCount) {
            this.setValueCount(outputRecords);
            this.hasRemainder = true;
            this.recordCount = this.remainderIndex = outputRecords;
        } else {
            this.setValueCount(incomingRecordCount);
            for (VectorWrapper v : this.incoming) {
                v.clear();
            }
            this.recordCount = outputRecords;
        }
        if (this.complexWriters != null) {
            this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        }
        return RecordBatch.IterOutcome.OK;
    }

    private void handleRemainder() {
        int remainingRecordCount = this.incoming.getRecordCount() - this.remainderIndex;
        if (!this.doAlloc()) {
            this.outOfMemory = true;
            return;
        }
        int projRecords = this.projector.projectRecords(this.remainderIndex, remainingRecordCount, 0);
        if (projRecords < remainingRecordCount) {
            this.setValueCount(projRecords);
            this.recordCount = projRecords;
            this.remainderIndex += projRecords;
        } else {
            this.setValueCount(remainingRecordCount);
            this.hasRemainder = false;
            this.remainderIndex = 0;
            for (VectorWrapper v : this.incoming) {
                v.clear();
            }
            this.recordCount = remainingRecordCount;
        }
        if (this.complexWriters != null) {
            this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
        }
    }

    private boolean doAlloc() {
        for (ValueVector v : this.allocationVectors) {
            if (v.allocateNewSafe()) continue;
            return false;
        }
        if (this.complexWriters == null) {
            return true;
        }
        for (BaseWriter.ComplexWriter writer : this.complexWriters) {
            writer.allocate();
        }
        return true;
    }

    private void setValueCount(int count) {
        for (ValueVector v : this.allocationVectors) {
            ValueVector.Mutator m = v.getMutator();
            m.setValueCount(count);
        }
        if (this.complexWriters == null) {
            return;
        }
        for (BaseWriter.ComplexWriter writer : this.complexWriters) {
            writer.setValueCount(count);
        }
    }

    private FieldReference getRef(NamedExpression e) {
        FieldReference ref = e.getRef();
        PathSegment.NameSegment seg = ref.getRootSegment();
        return ref;
    }

    private boolean isAnyWildcard(List<NamedExpression> exprs) {
        for (NamedExpression e : exprs) {
            if (!this.isWildcard(e)) continue;
            return true;
        }
        return false;
    }

    private boolean isWildcard(NamedExpression ex) {
        if (!(ex.getExpr() instanceof SchemaPath)) {
            return false;
        }
        PathSegment.NameSegment expr = ((SchemaPath)ex.getExpr()).getRootSegment();
        return expr.getPath().contains("*");
    }

    @Override
    protected boolean setupNewSchema() throws SchemaChangeException {
        if (this.allocationVectors != null) {
            for (ValueVector v : this.allocationVectors) {
                v.clear();
            }
        }
        this.allocationVectors = Lists.newArrayList();
        if (this.complexWriters != null) {
            this.container.clear();
        } else {
            this.container.zeroVectors();
        }
        List<NamedExpression> exprs = this.getExpressionList();
        ErrorCollectorImpl collector = new ErrorCollectorImpl();
        ArrayList<TransferPair> transfers = Lists.newArrayList();
        ClassGenerator<Projector> cg = CodeGenerator.getRoot(Projector.TEMPLATE_DEFINITION, this.context.getFunctionRegistry());
        IntOpenHashSet transferFieldIds = new IntOpenHashSet();
        boolean isAnyWildcard = this.isAnyWildcard(exprs);
        ClassifierResult result = new ClassifierResult();
        boolean classify = this.isClassificationNeeded(exprs);
        for (int i = 0; i < exprs.size(); ++i) {
            NamedExpression namedExpression = exprs.get(i);
            result.clear();
            if (classify && namedExpression.getExpr() instanceof SchemaPath) {
                this.classifyExpr(namedExpression, this.incoming, result);
                if (result.isStar) {
                    String name;
                    SchemaPath originalPath;
                    ValueVector vvIn;
                    Integer value = result.prefixMap.get(result.prefix);
                    if (value != null && value == 1) {
                        int k = 0;
                        for (VectorWrapper wrapper : this.incoming) {
                            vvIn = wrapper.getValueVector();
                            originalPath = vvIn.getField().getPath();
                            if (k > result.outputNames.size() - 1) assert (false);
                            if ((name = result.outputNames.get(k++)) == "") continue;
                            FieldReference ref = new FieldReference(name);
                            Object vvOut = this.container.addOrGet(MaterializedField.create(ref, vvIn.getField().getType()));
                            TransferPair tp = vvIn.makeTransferPair((ValueVector)vvOut);
                            transfers.add(tp);
                        }
                        continue;
                    }
                    if (value == null || value <= 1) continue;
                    int k = 0;
                    for (VectorWrapper wrapper : this.incoming) {
                        vvIn = wrapper.getValueVector();
                        originalPath = vvIn.getField().getPath();
                        if (k > result.outputNames.size() - 1) assert (false);
                        if ((name = result.outputNames.get(k++)) == "") continue;
                        LogicalExpression expr = ExpressionTreeMaterializer.materialize(originalPath, this.incoming, collector, this.context.getFunctionRegistry());
                        if (collector.hasErrors()) {
                            throw new SchemaChangeException(String.format("Failure while trying to materialize incoming schema.  Errors:\n %s.", collector.toErrorString()));
                        }
                        MaterializedField outputField = MaterializedField.create(name, expr.getMajorType());
                        Object vv = this.container.addOrGet(outputField, this.callBack);
                        this.allocationVectors.add((ValueVector)vv);
                        TypedFieldId fid = this.container.getValueVectorId(outputField.getPath());
                        ValueVectorWriteExpression write = new ValueVectorWriteExpression(fid, expr, true);
                        ClassGenerator.HoldingContainer hc = cg.addExpr(write);
                        cg.getEvalBlock()._if(hc.getValue().eq(JExpr.lit((int)0)))._then()._return(JExpr.FALSE);
                    }
                    continue;
                }
            }
            String outputName = this.getRef(namedExpression).getRootSegment().getPath();
            if (result != null && result.outputNames != null && result.outputNames.size() > 0) {
                for (int j = 0; j < result.outputNames.size(); ++j) {
                    if (result.outputNames.get(j).equals("")) continue;
                    outputName = result.outputNames.get(j);
                    break;
                }
            }
            LogicalExpression expr = ExpressionTreeMaterializer.materialize(namedExpression.getExpr(), this.incoming, collector, this.context.getFunctionRegistry(), true);
            MaterializedField outputField = MaterializedField.create(outputName, expr.getMajorType());
            if (collector.hasErrors()) {
                throw new SchemaChangeException(String.format("Failure while trying to materialize incoming schema.  Errors:\n %s.", collector.toErrorString()));
            }
            if (expr instanceof ValueVectorReadExpression && this.incoming.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.NONE && !((ValueVectorReadExpression)expr).hasReadPath() && !isAnyWildcard && !transferFieldIds.contains(((ValueVectorReadExpression)expr).getFieldId().getFieldIds()[0])) {
                ValueVectorReadExpression vectorRead = (ValueVectorReadExpression)expr;
                TypedFieldId id = vectorRead.getFieldId();
                ValueVector vvIn = this.incoming.getValueAccessorById(id.getIntermediateClass(), id.getFieldIds()).getValueVector();
                Preconditions.checkNotNull(this.incoming);
                FieldReference ref = this.getRef(namedExpression);
                Object vvOut = this.container.addOrGet(MaterializedField.create(ref, vectorRead.getMajorType()));
                TransferPair tp = vvIn.makeTransferPair((ValueVector)vvOut);
                transfers.add(tp);
                transferFieldIds.add(vectorRead.getFieldId().getFieldIds()[0]);
                logger.debug("Added transfer for project expression.");
                continue;
            }
            if (expr instanceof DrillFuncHolderExpr && ((DrillFuncHolderExpr)expr).isComplexWriterFuncHolder()) {
                if (this.complexWriters == null) {
                    this.complexWriters = Lists.newArrayList();
                } else {
                    this.complexWriters.clear();
                }
                ((DrillComplexWriterFuncHolder)((DrillFuncHolderExpr)expr).getHolder()).setReference(namedExpression.getRef());
                cg.addExpr(expr);
                continue;
            }
            Object vector = this.container.addOrGet(outputField, this.callBack);
            this.allocationVectors.add((ValueVector)vector);
            TypedFieldId fid = this.container.getValueVectorId(outputField.getPath());
            ValueVectorWriteExpression write = new ValueVectorWriteExpression(fid, expr, true);
            ClassGenerator.HoldingContainer hc = cg.addExpr(write);
            cg.getEvalBlock()._if(hc.getValue().eq(JExpr.lit((int)0)))._then()._return(JExpr.FALSE);
            logger.debug("Added eval for project expression.");
        }
        cg.rotateBlock();
        cg.getEvalBlock()._return(JExpr.TRUE);
        try {
            this.projector = this.context.getImplementationClass(cg.getCodeGenerator());
            this.projector.setup(this.context, this.incoming, this, transfers);
        }
        catch (IOException | ClassTransformationException e) {
            throw new SchemaChangeException("Failure while attempting to load generated class", e);
        }
        if (this.container.isSchemaChanged()) {
            this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
            return true;
        }
        return false;
    }

    private List<NamedExpression> getExpressionList() {
        if (((Project)this.popConfig).getExprs() != null) {
            return ((Project)this.popConfig).getExprs();
        }
        ArrayList<NamedExpression> exprs = Lists.newArrayList();
        for (MaterializedField field : this.incoming.getSchema()) {
            if (Types.isComplex(field.getType()) || Types.isRepeated(field.getType())) {
                LogicalExpression convertToJson = FunctionCallFactory.createConvert("convert_to", "JSON", field.getPath(), ExpressionPosition.UNKNOWN);
                String castFuncName = CastFunctions.getCastFunc(TypeProtos.MinorType.VARCHAR);
                ArrayList<LogicalExpression> castArgs = Lists.newArrayList();
                castArgs.add(convertToJson);
                castArgs.add(new ValueExpressions.LongExpression(65536L, null));
                FunctionCall castCall = new FunctionCall(castFuncName, castArgs, ExpressionPosition.UNKNOWN);
                exprs.add(new NamedExpression(castCall, new FieldReference(field.getPath())));
                continue;
            }
            exprs.add(new NamedExpression(field.getPath(), new FieldReference(field.getPath())));
        }
        return exprs;
    }

    private boolean isClassificationNeeded(List<NamedExpression> exprs) {
        boolean needed = false;
        for (int i = 0; i < exprs.size(); ++i) {
            NamedExpression ex = exprs.get(i);
            if (!(ex.getExpr() instanceof SchemaPath)) continue;
            PathSegment.NameSegment expr = ((SchemaPath)ex.getExpr()).getRootSegment();
            PathSegment.NameSegment ref = ex.getRef().getRootSegment();
            boolean refHasPrefix = ref.getPath().contains("\u00a6\u00a6");
            boolean exprContainsStar = expr.getPath().contains("*");
            if (!refHasPrefix && !exprContainsStar) continue;
            needed = true;
            break;
        }
        return needed;
    }

    private String getUniqueName(String name, ClassifierResult result) {
        Integer currentSeq = (Integer)result.sequenceMap.get((Object)name);
        if (currentSeq == null) {
            Integer n = -1;
            result.sequenceMap.put((Object)name, (Object)n);
            return name;
        }
        Integer newSeq = currentSeq + 1;
        result.sequenceMap.put((Object)name, (Object)newSeq);
        String newName = name + newSeq;
        return newName;
    }

    private void addToResultMaps(String origName, ClassifierResult result, boolean allowDupsWithRename) {
        String name = origName;
        if (allowDupsWithRename) {
            name = this.getUniqueName(origName, result);
        }
        if (!result.outputMap.containsKey((Object)name)) {
            result.outputNames.add(name);
            result.outputMap.put((Object)name, (Object)name);
        } else {
            result.outputNames.add("");
        }
    }

    private void classifyExpr(NamedExpression ex, RecordBatch incoming, ClassifierResult result) {
        String newName;
        PathSegment.NameSegment expr = ((SchemaPath)ex.getExpr()).getRootSegment();
        PathSegment.NameSegment ref = ex.getRef().getRootSegment();
        boolean exprHasPrefix = expr.getPath().contains("\u00a6\u00a6");
        boolean refHasPrefix = ref.getPath().contains("\u00a6\u00a6");
        boolean exprIsStar = expr.getPath().equals("*");
        boolean refContainsStar = ref.getPath().contains("*");
        boolean exprContainsStar = expr.getPath().contains("*");
        boolean refEndsWithStar = ref.getPath().endsWith("*");
        String exprPrefix = "";
        String exprSuffix = expr.getPath();
        if (exprHasPrefix) {
            String[] exprComponents = expr.getPath().split("\u00a6\u00a6", 2);
            assert (exprComponents.length == 2);
            exprPrefix = exprComponents[0];
            exprSuffix = exprComponents[1];
            result.prefix = exprPrefix;
        }
        if (exprContainsStar) {
            Integer n;
            result.isStar = true;
            Integer value = result.prefixMap.get(exprPrefix);
            if (value == null) {
                n = 1;
                result.prefixMap.put(exprPrefix, n);
            } else {
                n = value + 1;
                result.prefixMap.put(exprPrefix, n);
            }
        }
        int incomingSchemaSize = incoming.getSchema().getFieldCount();
        if (exprIsStar && refHasPrefix && refEndsWithStar) {
            String[] components = ref.getPath().split("\u00a6\u00a6", 2);
            assert (components.length == 2);
            String prefix = components[0];
            result.outputNames = Lists.newArrayList();
            for (VectorWrapper wrapper : incoming) {
                ValueVector vvIn = wrapper.getValueVector();
                String name = vvIn.getField().getPath().getRootSegment().getPath();
                String newName2 = prefix + "\u00a6\u00a6" + name;
                this.addToResultMaps(newName2, result, false);
            }
        } else if (expr.getPath().equals(ref.getPath())) {
            if (exprContainsStar && exprHasPrefix) {
                assert (exprPrefix != null);
                int k = 0;
                result.outputNames = Lists.newArrayListWithCapacity(incomingSchemaSize);
                for (int j = 0; j < incomingSchemaSize; ++j) {
                    result.outputNames.add("");
                }
                for (VectorWrapper wrapper : incoming) {
                    String newName3;
                    ValueVector vvIn = wrapper.getValueVector();
                    String incomingName = vvIn.getField().getPath().getRootSegment().getPath();
                    String[] nameComponents = incomingName.split("\u00a6\u00a6", 2);
                    if (nameComponents.length <= 1) {
                        ++k;
                        continue;
                    }
                    String namePrefix = nameComponents[0];
                    if (exprPrefix.equals(namePrefix) && !result.outputMap.containsKey((Object)(newName3 = incomingName))) {
                        result.outputNames.set(k, newName3);
                        result.outputMap.put((Object)newName3, (Object)newName3);
                    }
                    ++k;
                }
            } else {
                result.outputNames = Lists.newArrayList();
                if (exprContainsStar) {
                    for (VectorWrapper wrapper : incoming) {
                        ValueVector vvIn = wrapper.getValueVector();
                        String incomingName = vvIn.getField().getPath().getRootSegment().getPath();
                        if (refContainsStar) {
                            this.addToResultMaps(incomingName, result, true);
                            continue;
                        }
                        this.addToResultMaps(incomingName, result, false);
                    }
                } else {
                    newName = expr.getPath();
                    if (!refHasPrefix && !exprHasPrefix) {
                        this.addToResultMaps(newName, result, true);
                    } else {
                        this.addToResultMaps(newName, result, false);
                    }
                }
            }
        } else if (!exprHasPrefix && refHasPrefix) {
            result.outputNames = Lists.newArrayList();
            newName = ref.getPath();
            this.addToResultMaps(newName, result, false);
        } else if (exprHasPrefix && !refHasPrefix) {
            int k = 0;
            result.outputNames = Lists.newArrayListWithCapacity(incomingSchemaSize);
            for (int j = 0; j < incomingSchemaSize; ++j) {
                result.outputNames.add("");
            }
            for (VectorWrapper wrapper : incoming) {
                ValueVector vvIn = wrapper.getValueVector();
                String name = vvIn.getField().getPath().getRootSegment().getPath();
                String[] components = name.split("\u00a6\u00a6", 2);
                if (components.length <= 1) {
                    ++k;
                    continue;
                }
                String namePrefix = components[0];
                String nameSuffix = components[1];
                if (exprPrefix.equals(namePrefix)) {
                    String newName4;
                    if (refContainsStar) {
                        newName4 = this.getUniqueName(nameSuffix, result);
                        result.outputNames.set(k, newName4);
                    } else if (exprSuffix.equals(nameSuffix)) {
                        newName4 = ref.getPath();
                        result.outputNames.set(k, newName4);
                    }
                } else {
                    result.outputNames.add("");
                }
                ++k;
            }
        } else if (exprHasPrefix && refHasPrefix) {
            String[] input = expr.getPath().split("\u00a6\u00a6", 2);
            assert (input.length == 2);
            assert (false) : "Unexpected project expression or reference";
        } else {
            result.outputNames = Lists.newArrayListWithCapacity(incomingSchemaSize);
            for (int j = 0; j < incomingSchemaSize; ++j) {
                result.outputNames.add("");
            }
            int k = 0;
            for (VectorWrapper wrapper : incoming) {
                String newName5;
                ValueVector vvIn = wrapper.getValueVector();
                String incomingName = vvIn.getField().getPath().getRootSegment().getPath();
                if (expr.getPath().equals(incomingName) && !result.outputMap.containsKey((Object)(newName5 = ref.getPath()))) {
                    result.outputNames.set(k, newName5);
                    result.outputMap.put((Object)newName5, (Object)newName5);
                }
                ++k;
            }
        }
    }

    private class ClassifierResult {
        public boolean isStar = false;
        public List<String> outputNames;
        public String prefix = "";
        public HashMap<String, Integer> prefixMap = Maps.newHashMap();
        public CaseInsensitiveMap outputMap = new CaseInsensitiveMap();
        private CaseInsensitiveMap sequenceMap = new CaseInsensitiveMap();

        private ClassifierResult() {
        }

        private void clear() {
            this.isStar = false;
            this.prefix = "";
            if (this.outputNames != null) {
                this.outputNames.clear();
            }
        }
    }
}

