/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.mergereceiver;

import com.google.common.collect.Lists;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.FunctionHolderExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.compile.sig.MappingSet;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.MetricDef;
import org.apache.drill.exec.physical.config.MergingReceiverPOP;
import org.apache.drill.exec.physical.impl.mergereceiver.MergingReceiverGeneratorBase;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.AbstractRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.ExpandableHyperContainer;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RawFragmentBatch;
import org.apache.drill.exec.record.RawFragmentBatchProvider;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.record.SchemaBuilder;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.record.selection.SelectionVector2;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.exec.vector.CopyUtil;
import org.eigenbase.rel.RelFieldCollation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import parquet.Preconditions;

public class MergingRecordBatch
extends AbstractRecordBatch<MergingReceiverPOP>
implements RecordBatch {
    static final Logger logger = LoggerFactory.getLogger(MergingRecordBatch.class);
    private RecordBatchLoader[] batchLoaders;
    private RawFragmentBatchProvider[] fragProviders;
    private FragmentContext context;
    private BatchSchema schema;
    private VectorContainer outgoingContainer;
    private MergingReceiverGeneratorBase merger;
    private MergingReceiverPOP config;
    private boolean hasRun;
    private boolean prevBatchWasFull;
    private boolean hasMoreIncoming;
    private int outgoingPosition;
    private int senderCount;
    private RawFragmentBatch[] incomingBatches;
    private int[] batchOffsets;
    private PriorityQueue<Node> pqueue;
    private RawFragmentBatch emptyBatch;
    private RawFragmentBatch[] tempBatchHolder;
    public final MappingSet MAIN_MAPPING;
    public final MappingSet LEFT_MAPPING;
    public final MappingSet RIGHT_MAPPING;
    public final MappingSet COPIER_MAPPING_SET;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RawFragmentBatch getNext(RawFragmentBatchProvider provider) throws IOException {
        this.stats.startWait();
        try {
            RawFragmentBatch b = provider.getNext();
            if (b != null) {
                this.stats.addLongStat(Metric.BYTES_RECEIVED, b.getByteCount());
                this.stats.batchReceived(0, b.getHeader().getDef().getRecordCount(), false);
            }
            RawFragmentBatch rawFragmentBatch = b;
            return rawFragmentBatch;
        }
        finally {
            this.stats.stopWait();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RecordBatch.IterOutcome innerNext() {
        if (this.fragProviders.length == 0) {
            return RecordBatch.IterOutcome.NONE;
        }
        boolean schemaChanged = false;
        if (this.prevBatchWasFull) {
            logger.debug("Outgoing vectors were full on last iteration");
            this.allocateOutgoing();
            this.outgoingPosition = 0;
            this.prevBatchWasFull = false;
        }
        if (!this.hasMoreIncoming) {
            logger.debug("next() was called after all values have been processed");
            this.outgoingPosition = 0;
            return RecordBatch.IterOutcome.NONE;
        }
        if (!this.hasRun) {
            int i;
            schemaChanged = true;
            ArrayList<Object> rawBatches = Lists.newArrayList();
            int p = 0;
            for (RawFragmentBatchProvider provider : this.fragProviders) {
                RawFragmentBatch rawFragmentBatch;
                void var8_24;
                Object var8_21 = null;
                try {
                    if (this.tempBatchHolder[p] != null) {
                        RawFragmentBatch rawFragmentBatch2 = this.tempBatchHolder[p];
                        this.tempBatchHolder[p] = null;
                    } else {
                        RawFragmentBatch rawFragmentBatch3 = this.getNext(provider);
                    }
                    ++p;
                    if (var8_24 == null && this.context.isCancelled()) {
                        return RecordBatch.IterOutcome.STOP;
                    }
                }
                catch (IOException e) {
                    this.context.fail(e);
                    return RecordBatch.IterOutcome.STOP;
                }
                if (var8_24.getHeader().getDef().getRecordCount() != 0) {
                    rawBatches.add(var8_24);
                    continue;
                }
                if (this.emptyBatch == null && var8_24.getHeader().getDef().getFieldCount() != 0) {
                    this.emptyBatch = var8_24;
                }
                try {
                    while ((rawFragmentBatch = this.getNext(provider)) != null && rawFragmentBatch.getHeader().getDef().getRecordCount() == 0) {
                    }
                    if (rawFragmentBatch == null && this.context.isCancelled()) {
                        return RecordBatch.IterOutcome.STOP;
                    }
                }
                catch (IOException e) {
                    this.context.fail(e);
                    return RecordBatch.IterOutcome.STOP;
                }
                if (rawFragmentBatch != null) {
                    rawBatches.add(rawFragmentBatch);
                    continue;
                }
                rawBatches.add(this.emptyBatch);
            }
            this.senderCount = rawBatches.size();
            this.incomingBatches = new RawFragmentBatch[this.senderCount];
            this.batchOffsets = new int[this.senderCount];
            this.batchLoaders = new RecordBatchLoader[this.senderCount];
            for (i = 0; i < this.senderCount; ++i) {
                this.incomingBatches[i] = (RawFragmentBatch)rawBatches.get(i);
                this.batchLoaders[i] = new RecordBatchLoader(this.oContext.getAllocator());
            }
            i = 0;
            for (RawFragmentBatch rawFragmentBatch : this.incomingBatches) {
                UserBitShared.RecordBatchDef rbd = rawFragmentBatch.getHeader().getDef();
                try {
                    this.batchLoaders[i].load(rbd, rawFragmentBatch.getBody());
                }
                catch (SchemaChangeException e) {
                    logger.error("MergingReceiver failed to load record batch from remote host.  {}", e);
                    this.context.fail(e);
                    return RecordBatch.IterOutcome.STOP;
                }
                rawFragmentBatch.release();
                int n = i++;
                this.batchOffsets[n] = this.batchOffsets[n] + 1;
            }
            for (RecordBatchLoader recordBatchLoader : this.batchLoaders) {
                recordBatchLoader.canonicalize();
            }
            if (!this.isSameSchemaAmongBatches(this.batchLoaders)) {
                logger.error("Incoming batches for merging receiver have diffferent schemas!");
                this.context.fail(new SchemaChangeException("Incoming batches for merging receiver have diffferent schemas!"));
                return RecordBatch.IterOutcome.STOP;
            }
            SchemaBuilder bldr = BatchSchema.newBuilder().setSelectionVectorMode(BatchSchema.SelectionVectorMode.NONE);
            int vectorCount = 0;
            for (VectorWrapper<?> vectorWrapper : this.batchLoaders[0]) {
                bldr.addField(vectorWrapper.getField());
                Object outgoingVector = this.outgoingContainer.addOrGet(vectorWrapper.getField());
                outgoingVector.allocateNew();
                ++vectorCount;
            }
            this.schema = bldr.build();
            if (this.schema != null && !this.schema.equals(this.schema)) {
                logger.debug("Initial state has incoming batches with different schemas");
            }
            this.outgoingContainer.buildSchema(BatchSchema.SelectionVectorMode.NONE);
            try {
                this.merger = this.createMerger();
            }
            catch (SchemaChangeException e) {
                logger.error("Failed to generate code for MergingReceiver.  {}", e);
                this.context.fail(e);
                return RecordBatch.IterOutcome.STOP;
            }
            this.pqueue = new PriorityQueue<Node>(this.fragProviders.length, new Comparator<Node>(){

                @Override
                public int compare(Node node1, Node node2) {
                    int leftIndex = (node1.batchId << 16) + node1.valueIndex;
                    int rightIndex = (node2.batchId << 16) + node2.valueIndex;
                    return MergingRecordBatch.this.merger.doEval(leftIndex, rightIndex);
                }
            });
            for (int b = 0; b < this.senderCount; ++b) {
                while (this.batchLoaders[b] != null && this.batchLoaders[b].getRecordCount() == 0) {
                    try {
                        RawFragmentBatch rawFragmentBatch;
                        this.incomingBatches[b] = rawFragmentBatch = this.getNext(this.fragProviders[b]);
                        if (rawFragmentBatch != null) {
                            this.batchLoaders[b].load(rawFragmentBatch.getHeader().getDef(), rawFragmentBatch.getBody());
                            continue;
                        }
                        this.batchLoaders[b].clear();
                        this.batchLoaders[b] = null;
                        if (!this.context.isCancelled()) continue;
                        return RecordBatch.IterOutcome.STOP;
                    }
                    catch (IOException | SchemaChangeException exception) {
                        this.context.fail(exception);
                        return RecordBatch.IterOutcome.STOP;
                    }
                }
                if (this.batchLoaders[b] == null) continue;
                this.pqueue.add(new Node(b, 0));
            }
            this.hasRun = true;
        }
        while (!this.pqueue.isEmpty()) {
            Node node = this.pqueue.peek();
            if (!this.copyRecordToOutgoingBatch(node)) {
                logger.debug("Outgoing vectors space is full; breaking");
                this.prevBatchWasFull = true;
                break;
            }
            this.pqueue.poll();
            if (node.valueIndex == this.batchLoaders[node.batchId].getRecordCount() - 1) {
                RawFragmentBatch nextBatch = null;
                try {
                    nextBatch = this.getNext(this.fragProviders[node.batchId]);
                    while (nextBatch != null && nextBatch.getHeader().getDef().getRecordCount() == 0) {
                        nextBatch = this.getNext(this.fragProviders[node.batchId]);
                    }
                    if (nextBatch == null && this.context.isCancelled()) {
                        return RecordBatch.IterOutcome.STOP;
                    }
                }
                catch (IOException e) {
                    this.context.fail(e);
                    return RecordBatch.IterOutcome.STOP;
                }
                this.incomingBatches[node.batchId] = nextBatch;
                if (nextBatch == null) {
                    boolean allBatchesEmpty = true;
                    for (RawFragmentBatch rawFragmentBatch : this.incomingBatches) {
                        if (rawFragmentBatch == null) continue;
                        allBatchesEmpty = false;
                        break;
                    }
                    if (!allBatchesEmpty) continue;
                    this.hasMoreIncoming = false;
                    break;
                }
                UserBitShared.RecordBatchDef rbd = this.incomingBatches[node.batchId].getHeader().getDef();
                try {
                    this.batchLoaders[node.batchId].load(rbd, this.incomingBatches[node.batchId].getBody());
                }
                catch (SchemaChangeException ex) {
                    this.context.fail(ex);
                    return RecordBatch.IterOutcome.STOP;
                }
                this.incomingBatches[node.batchId].release();
                this.batchOffsets[node.batchId] = 0;
                if (this.batchLoaders[node.batchId].getRecordCount() != 0) {
                    this.pqueue.add(new Node(node.batchId, 0));
                }
            } else {
                this.pqueue.add(new Node(node.batchId, node.valueIndex + 1));
            }
            if (!this.prevBatchWasFull) continue;
            break;
        }
        for (VectorWrapper<?> vw : this.outgoingContainer) {
            vw.getValueVector().getMutator().setValueCount(this.outgoingPosition);
        }
        if (this.pqueue.isEmpty()) {
            this.state = AbstractRecordBatch.BatchState.DONE;
        }
        if (schemaChanged) {
            return RecordBatch.IterOutcome.OK_NEW_SCHEMA;
        }
        return RecordBatch.IterOutcome.OK;
    }

    @Override
    public FragmentContext getContext() {
        return this.context;
    }

    @Override
    public BatchSchema getSchema() {
        return this.outgoingContainer.getSchema();
    }

    @Override
    public void buildSchema() {
        this.tempBatchHolder = new RawFragmentBatch[this.fragProviders.length];
        int i = 0;
        try {
            RawFragmentBatch batch;
            while (true) {
                if (i >= this.fragProviders.length) {
                    this.state = AbstractRecordBatch.BatchState.DONE;
                    return;
                }
                batch = this.getNext(this.fragProviders[i]);
                if (batch.getHeader().getDef().getFieldCount() != 0) break;
                ++i;
            }
            this.tempBatchHolder[i] = batch;
            for (UserBitShared.SerializedField field : batch.getHeader().getDef().getFieldList()) {
                Object v = this.outgoingContainer.addOrGet(MaterializedField.create(field));
                v.allocateNew();
            }
        }
        catch (IOException e) {
            throw new DrillRuntimeException(e);
        }
        this.outgoingContainer = VectorContainer.canonicalize(this.outgoingContainer);
        this.outgoingContainer.buildSchema(BatchSchema.SelectionVectorMode.NONE);
    }

    @Override
    public int getRecordCount() {
        return this.outgoingPosition;
    }

    @Override
    public void kill(boolean sendUpstream) {
        if (sendUpstream) {
            this.informSenders();
        } else {
            this.cleanup();
            for (RawFragmentBatchProvider provider : this.fragProviders) {
                provider.kill(this.context);
            }
        }
    }

    private void informSenders() {
        ExecProtos.FragmentHandle handlePrototype = ExecProtos.FragmentHandle.newBuilder().setMajorFragmentId(this.config.getOppositeMajorFragmentId()).setQueryId(this.context.getHandle().getQueryId()).build();
        for (int i = 0; i < this.config.getNumSenders(); ++i) {
            ExecProtos.FragmentHandle sender = ExecProtos.FragmentHandle.newBuilder(handlePrototype).setMinorFragmentId(i).build();
            BitControl.FinishedReceiver finishedReceiver = BitControl.FinishedReceiver.newBuilder().setReceiver(this.context.getHandle()).setSender(sender).build();
            this.context.getControlTunnel(this.config.getProvidingEndpoints().get(i)).informReceiverFinished(new OutcomeListener(), finishedReceiver);
        }
    }

    @Override
    protected void killIncoming(boolean sendUpstream) {
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.outgoingContainer.iterator();
    }

    @Override
    public SelectionVector2 getSelectionVector2() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        return this.outgoingContainer.getValueVectorId(path);
    }

    @Override
    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... ids) {
        return this.outgoingContainer.getValueAccessorById(clazz, ids);
    }

    @Override
    public WritableBatch getWritableBatch() {
        return WritableBatch.get(this);
    }

    private boolean isSameSchemaAmongBatches(RecordBatchLoader[] batchLoaders) {
        Preconditions.checkArgument(batchLoaders.length > 0, "0 batch is not allowed!");
        BatchSchema schema = batchLoaders[0].getSchema();
        for (int i = 1; i < batchLoaders.length; ++i) {
            if (schema.equals(batchLoaders[i].getSchema())) continue;
            logger.error("Schemas are different. Schema 1 : " + schema + ", Schema 2: " + batchLoaders[i].getSchema());
            return false;
        }
        return true;
    }

    private void allocateOutgoing() {
        this.outgoingContainer.allocateNew();
    }

    private MergingReceiverGeneratorBase createMerger() throws SchemaChangeException {
        try {
            CodeGenerator<MergingReceiverGeneratorBase> cg = CodeGenerator.get(MergingReceiverGeneratorBase.TEMPLATE_DEFINITION, this.context.getFunctionRegistry());
            ClassGenerator<MergingReceiverGeneratorBase> g = cg.getRoot();
            ExpandableHyperContainer batch = null;
            boolean first = true;
            for (RecordBatchLoader loader : this.batchLoaders) {
                if (first) {
                    batch = new ExpandableHyperContainer(loader);
                    first = false;
                    continue;
                }
                batch.addBatch(loader);
            }
            this.generateComparisons(g, batch);
            g.setMappingSet(this.COPIER_MAPPING_SET);
            CopyUtil.generateCopies(g, batch, true);
            g.setMappingSet(this.MAIN_MAPPING);
            MergingReceiverGeneratorBase merger = this.context.getImplementationClass(cg);
            merger.doSetup(this.context, batch, this.outgoingContainer);
            return merger;
        }
        catch (IOException | ClassTransformationException e) {
            throw new SchemaChangeException(e);
        }
    }

    private void generateComparisons(ClassGenerator g, VectorAccessible batch) throws SchemaChangeException {
        g.setMappingSet(this.MAIN_MAPPING);
        for (Order.Ordering od : ((MergingReceiverPOP)this.popConfig).getOrderings()) {
            ErrorCollectorImpl collector = new ErrorCollectorImpl();
            LogicalExpression expr = ExpressionTreeMaterializer.materialize(od.getExpr(), batch, collector, this.context.getFunctionRegistry());
            if (collector.hasErrors()) {
                throw new SchemaChangeException("Failure while materializing expression. " + collector.toErrorString());
            }
            g.setMappingSet(this.LEFT_MAPPING);
            ClassGenerator.HoldingContainer left = g.addExpr(expr, false);
            g.setMappingSet(this.RIGHT_MAPPING);
            ClassGenerator.HoldingContainer right = g.addExpr(expr, false);
            g.setMappingSet(this.MAIN_MAPPING);
            FunctionHolderExpression fh = FunctionGenerationHelper.getComparator(left, right, this.context.getFunctionRegistry());
            ClassGenerator.HoldingContainer out = g.addExpr(fh, false);
            JConditional jc = g.getEvalBlock()._if(out.getValue().ne(JExpr.lit((int)0)));
            if (od.getDirection() == RelFieldCollation.Direction.ASCENDING) {
                jc._then()._return((JExpression)out.getValue());
                continue;
            }
            jc._then()._return(out.getValue().minus());
        }
        g.getEvalBlock()._return(JExpr.lit((int)0));
    }

    private boolean copyRecordToOutgoingBatch(Node node) {
        int inIndex = (node.batchId << 16) + node.valueIndex;
        if (!this.merger.doCopy(inIndex, this.outgoingPosition)) {
            return false;
        }
        ++this.outgoingPosition;
        return true;
    }

    @Override
    public void cleanup() {
        this.outgoingContainer.clear();
        if (this.batchLoaders != null) {
            for (RecordBatchLoader rbl : this.batchLoaders) {
                if (rbl == null) continue;
                rbl.clear();
            }
        }
        this.oContext.close();
        if (this.fragProviders != null) {
            for (RawFragmentBatchProvider f : this.fragProviders) {
                f.cleanup();
            }
        }
    }

    public class Node {
        public int batchId;
        public int valueIndex;

        Node(int batchId, int valueIndex) {
            this.batchId = batchId;
            this.valueIndex = valueIndex;
        }
    }

    private class OutcomeListener
    implements RpcOutcomeListener<GeneralRPCProtos.Ack> {
        private OutcomeListener() {
        }

        @Override
        public void failed(RpcException ex) {
            logger.warn("Failed to inform upstream that receiver is finished");
        }

        @Override
        public void success(GeneralRPCProtos.Ack value, ByteBuf buffer) {
        }
    }

    public static enum Metric implements MetricDef
    {
        BYTES_RECEIVED,
        NUM_SENDERS,
        NEXT_WAIT_NANOS;


        @Override
        public int metricId() {
            return this.ordinal();
        }
    }
}

