/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.materialize;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.apache.drill.exec.proto.UserBitShared;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryWritableBatch {
    static final Logger logger = LoggerFactory.getLogger(QueryWritableBatch.class);
    private final UserBitShared.QueryResult header;
    private final ByteBuf[] buffers;

    public QueryWritableBatch(UserBitShared.QueryResult header, ByteBuf ... buffers) {
        this.header = header;
        this.buffers = buffers;
    }

    public ByteBuf[] getBuffers() {
        return this.buffers;
    }

    public long getByteCount() {
        long n = 0L;
        for (ByteBuf buf : this.buffers) {
            n += (long)buf.readableBytes();
        }
        return n;
    }

    public UserBitShared.QueryResult getHeader() {
        return this.header;
    }

    public String toString() {
        return "QueryWritableBatch [header=" + this.header + ", buffers=" + Arrays.toString(this.buffers) + "]";
    }
}

