/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JVar;
import java.io.IOException;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.logical.data.JoinCondition;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.compile.sig.GeneratorMapping;
import org.apache.drill.exec.compile.sig.MappingSet;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.ops.MetricDef;
import org.apache.drill.exec.physical.config.HashJoinPOP;
import org.apache.drill.exec.physical.impl.common.ChainedHashTable;
import org.apache.drill.exec.physical.impl.common.HashTable;
import org.apache.drill.exec.physical.impl.common.HashTableConfig;
import org.apache.drill.exec.physical.impl.common.HashTableStats;
import org.apache.drill.exec.physical.impl.common.IndexPointer;
import org.apache.drill.exec.physical.impl.join.HashJoinHelper;
import org.apache.drill.exec.physical.impl.join.HashJoinProbe;
import org.apache.drill.exec.physical.impl.sort.RecordBatchData;
import org.apache.drill.exec.record.AbstractRecordBatch;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.ExpandableHyperContainer;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractContainerVector;
import org.eigenbase.rel.JoinRelType;

public class HashJoinBatch
extends AbstractRecordBatch<HashJoinPOP> {
    private final RecordBatch left;
    private final RecordBatch right;
    private final JoinRelType joinType;
    private final List<JoinCondition> conditions;
    private HashJoinProbe hashJoinProbe;
    private HashJoinHelper hjHelper;
    private HashTable hashTable;
    private ExpandableHyperContainer hyperContainer;
    private int outputRecords;
    private int buildBatchIndex;
    private BatchSchema rightSchema;
    private static final GeneratorMapping PROJECT_BUILD = GeneratorMapping.create("doSetup", "projectBuildRecord", null, null);
    private static final GeneratorMapping PROJECT_BUILD_CONSTANT = GeneratorMapping.create("doSetup", "doSetup", null, null);
    private static final GeneratorMapping PROJECT_PROBE = GeneratorMapping.create("doSetup", "projectProbeRecord", null, null);
    private static final GeneratorMapping PROJECT_PROBE_CONSTANT = GeneratorMapping.create("doSetup", "doSetup", null, null);
    private final MappingSet projectBuildMapping;
    private final MappingSet projectProbeMapping;
    RecordBatch.IterOutcome leftUpstream;
    RecordBatch.IterOutcome rightUpstream;
    private final HashTableStats htStats;

    @Override
    public int getRecordCount() {
        return this.outputRecords;
    }

    @Override
    protected void buildSchema() throws SchemaChangeException {
        this.leftUpstream = this.next(this.left);
        this.rightUpstream = this.next(this.right);
        this.hjHelper = new HashJoinHelper(this.context, this.oContext.getAllocator());
        try {
            this.rightSchema = this.right.getSchema();
            VectorContainer c = new VectorContainer(this.oContext);
            for (VectorWrapper w : this.right) {
                Object v = c.addOrGet(w.getField());
                if (!(v instanceof AbstractContainerVector)) continue;
                w.getValueVector().makeTransferPair((ValueVector)v);
                v.clear();
            }
            c.buildSchema(BatchSchema.SelectionVectorMode.NONE);
            c.setRecordCount(0);
            this.hyperContainer = new ExpandableHyperContainer(c);
            this.hjHelper.addNewBatch(0);
            ++this.buildBatchIndex;
            this.setupHashTable();
            this.hashJoinProbe = this.setupHashJoinProbe();
            for (VectorWrapper w : this.container) {
                w.getValueVector().allocateNew();
            }
            this.container.buildSchema(BatchSchema.SelectionVectorMode.NONE);
            this.container.setRecordCount(this.outputRecords);
        }
        catch (IOException | ClassTransformationException e) {
            throw new SchemaChangeException(e);
        }
    }

    @Override
    public RecordBatch.IterOutcome innerNext() {
        try {
            if (this.state == AbstractRecordBatch.BatchState.FIRST) {
                this.executeBuildPhase();
                this.hashJoinProbe.setupHashJoinProbe(this.context, this.hyperContainer, this.left, this.left.getRecordCount(), this, this.hashTable, this.hjHelper, this.joinType);
                this.updateStats(this.hashTable);
            }
            if (this.hashTable != null || this.joinType != JoinRelType.INNER) {
                this.allocateVectors();
                this.outputRecords = this.hashJoinProbe.probeAndProject();
                if (this.outputRecords > 0 || this.state == AbstractRecordBatch.BatchState.FIRST) {
                    if (this.state == AbstractRecordBatch.BatchState.FIRST) {
                        this.state = AbstractRecordBatch.BatchState.NOT_FIRST;
                    }
                    for (VectorWrapper<?> v : this.container) {
                        v.getValueVector().getMutator().setValueCount(this.outputRecords);
                    }
                    return RecordBatch.IterOutcome.OK;
                }
            } else if (this.leftUpstream == RecordBatch.IterOutcome.OK_NEW_SCHEMA || this.leftUpstream == RecordBatch.IterOutcome.OK) {
                for (VectorWrapper wrapper : this.left) {
                    wrapper.getValueVector().clear();
                }
                this.left.kill(true);
                this.leftUpstream = this.next(0, this.left);
                while (this.leftUpstream == RecordBatch.IterOutcome.OK_NEW_SCHEMA || this.leftUpstream == RecordBatch.IterOutcome.OK) {
                    for (VectorWrapper wrapper : this.left) {
                        wrapper.getValueVector().clear();
                    }
                    this.leftUpstream = this.next(0, this.left);
                }
            }
            this.state = AbstractRecordBatch.BatchState.DONE;
            return RecordBatch.IterOutcome.NONE;
        }
        catch (IOException | ClassTransformationException | SchemaChangeException e) {
            this.context.fail(e);
            this.killIncoming(false);
            return RecordBatch.IterOutcome.STOP;
        }
    }

    public void setupHashTable() throws IOException, SchemaChangeException, ClassTransformationException {
        int conditionsSize = this.conditions.size();
        NamedExpression[] rightExpr = new NamedExpression[conditionsSize];
        NamedExpression[] leftExpr = new NamedExpression[conditionsSize];
        for (int i = 0; i < conditionsSize; ++i) {
            rightExpr[i] = new NamedExpression(this.conditions.get(i).getRight(), new FieldReference("build_side_" + i));
            leftExpr[i] = new NamedExpression(this.conditions.get(i).getLeft(), new FieldReference("probe_side_" + i));
            assert (this.conditions.get(i).getRelationship().equals("=="));
        }
        if (this.leftUpstream != RecordBatch.IterOutcome.OK_NEW_SCHEMA && this.leftUpstream != RecordBatch.IterOutcome.OK) {
            leftExpr = null;
        } else if (this.left.getSchema().getSelectionVectorMode() != BatchSchema.SelectionVectorMode.NONE) {
            throw new SchemaChangeException("Hash join does not support probe batch with selection vectors");
        }
        HashTableConfig htConfig = new HashTableConfig(this.context.getOptions().getOption((String)"exec.min_hash_table_size").num_val.intValue(), 0.75f, rightExpr, leftExpr);
        ChainedHashTable ht = new ChainedHashTable(htConfig, this.context, this.oContext.getAllocator(), this.right, this.left, null);
        this.hashTable = ht.createAndSetupHashTable(null);
    }

    public void executeBuildPhase() throws SchemaChangeException, ClassTransformationException, IOException {
        if (this.right.getRecordCount() == 0) {
            for (VectorWrapper w : this.right) {
                w.clear();
            }
            this.rightUpstream = this.next(this.right);
        }
        boolean moreData = true;
        block6: while (moreData) {
            switch (this.rightUpstream) {
                case NONE: 
                case NOT_YET: 
                case STOP: {
                    moreData = false;
                    continue block6;
                }
                case OK_NEW_SCHEMA: {
                    if (this.rightSchema == null) {
                        this.rightSchema = this.right.getSchema();
                        if (this.rightSchema.getSelectionVectorMode() != BatchSchema.SelectionVectorMode.NONE) {
                            throw new SchemaChangeException("Hash join does not support build batch with selection vectors");
                        }
                        this.setupHashTable();
                    } else {
                        if (!this.rightSchema.equals(this.right.getSchema())) {
                            throw new SchemaChangeException("Hash join does not support schema changes");
                        }
                        this.hashTable.updateBatches();
                    }
                }
                case OK: {
                    int currentRecordCount = this.right.getRecordCount();
                    this.hjHelper.addNewBatch(currentRecordCount);
                    IndexPointer htIndex = new IndexPointer();
                    for (int i = 0; i < currentRecordCount; ++i) {
                        HashTable.PutStatus status = this.hashTable.put(i, htIndex, 1);
                        if (status == HashTable.PutStatus.PUT_FAILED) continue;
                        this.hjHelper.setCurrentIndex(htIndex.value, this.buildBatchIndex, i);
                    }
                    RecordBatchData nextBatch = new RecordBatchData(this.right);
                    if (this.hyperContainer == null) {
                        this.hyperContainer = new ExpandableHyperContainer(nextBatch.getContainer());
                    } else {
                        this.hyperContainer.addBatch(nextBatch.getContainer());
                    }
                    ++this.buildBatchIndex;
                }
            }
            this.rightUpstream = this.next(1, this.right);
        }
    }

    public HashJoinProbe setupHashJoinProbe() throws ClassTransformationException, IOException {
        CodeGenerator<HashJoinProbe> cg = CodeGenerator.get(HashJoinProbe.TEMPLATE_DEFINITION, this.context.getFunctionRegistry());
        ClassGenerator<HashJoinProbe> g = cg.getRoot();
        g.setMappingSet(this.projectBuildMapping);
        int fieldId = 0;
        JExpression buildIndex = JExpr.direct((String)"buildIndex");
        JExpression outIndex = JExpr.direct((String)"outIndex");
        g.rotateBlock();
        if (this.rightSchema != null) {
            for (MaterializedField field : this.rightSchema) {
                TypeProtos.MajorType inputType = field.getType();
                TypeProtos.MajorType outputType = this.joinType == JoinRelType.LEFT && inputType.getMode() == TypeProtos.DataMode.REQUIRED ? Types.overrideMode(inputType, TypeProtos.DataMode.OPTIONAL) : inputType;
                this.container.addOrGet(MaterializedField.create(field.getPath(), outputType));
                JVar inVV = g.declareVectorValueSetupAndMember("buildBatch", new TypedFieldId(field.getType(), true, fieldId));
                JVar outVV = g.declareVectorValueSetupAndMember("outgoing", new TypedFieldId(outputType, false, fieldId++));
                g.getEvalBlock()._if(outVV.invoke("copyFromSafe").arg(buildIndex.band(JExpr.lit((int)65535))).arg(outIndex).arg((JExpression)inVV.component(buildIndex.shrz(JExpr.lit((int)16)))).not())._then()._return(JExpr.FALSE);
            }
        }
        g.rotateBlock();
        g.getEvalBlock()._return(JExpr.TRUE);
        g.setMappingSet(this.projectProbeMapping);
        int outputFieldId = fieldId;
        fieldId = 0;
        JExpression probeIndex = JExpr.direct((String)"probeIndex");
        int recordCount = 0;
        if (this.leftUpstream == RecordBatch.IterOutcome.OK || this.leftUpstream == RecordBatch.IterOutcome.OK_NEW_SCHEMA) {
            for (VectorWrapper vv : this.left) {
                TypeProtos.MajorType inputType = vv.getField().getType();
                TypeProtos.MajorType outputType = this.joinType == JoinRelType.RIGHT && inputType.getMode() == TypeProtos.DataMode.REQUIRED ? Types.overrideMode(inputType, TypeProtos.DataMode.OPTIONAL) : inputType;
                Object v = this.container.addOrGet(MaterializedField.create(vv.getField().getPath(), outputType));
                if (v instanceof AbstractContainerVector) {
                    vv.getValueVector().makeTransferPair((ValueVector)v);
                    v.clear();
                }
                JVar inVV = g.declareVectorValueSetupAndMember("probeBatch", new TypedFieldId(inputType, false, fieldId++));
                JVar outVV = g.declareVectorValueSetupAndMember("outgoing", new TypedFieldId(outputType, false, outputFieldId++));
                g.getEvalBlock()._if(outVV.invoke("copyFromSafe").arg(probeIndex).arg(outIndex).arg((JExpression)inVV).not())._then()._return(JExpr.FALSE);
            }
            recordCount = this.left.getRecordCount();
        }
        g.rotateBlock();
        g.getEvalBlock()._return(JExpr.TRUE);
        HashJoinProbe hj = this.context.getImplementationClass(cg);
        return hj;
    }

    private void allocateVectors() {
        for (VectorWrapper<?> v : this.container) {
            v.getValueVector().allocateNew();
        }
    }

    private void updateStats(HashTable htable) {
        if (htable == null) {
            return;
        }
        htable.getStats(this.htStats);
        this.stats.setLongStat(Metric.NUM_BUCKETS, this.htStats.numBuckets);
        this.stats.setLongStat(Metric.NUM_ENTRIES, this.htStats.numEntries);
        this.stats.setLongStat(Metric.NUM_RESIZING, this.htStats.numResizing);
        this.stats.setLongStat(Metric.RESIZING_TIME, this.htStats.resizingTime);
    }

    @Override
    public void killIncoming(boolean sendUpstream) {
        this.left.kill(sendUpstream);
        this.right.kill(sendUpstream);
    }

    @Override
    public void cleanup() {
        if (this.hjHelper != null) {
            this.hjHelper.clear();
        }
        if (this.hyperContainer != null) {
            this.hyperContainer.clear();
        }
        if (this.hashTable != null) {
            this.hashTable.clear();
        }
        super.cleanup();
        this.right.cleanup();
        this.left.cleanup();
    }

    public static enum Metric implements MetricDef
    {
        NUM_BUCKETS,
        NUM_ENTRIES,
        NUM_RESIZING,
        RESIZING_TIME;


        @Override
        public int metricId() {
            return this.ordinal();
        }
    }
}

