/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.broadcastsender;

import io.netty.buffer.ByteBuf;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.MetricDef;
import org.apache.drill.exec.physical.config.BroadcastSender;
import org.apache.drill.exec.physical.impl.BaseRootExec;
import org.apache.drill.exec.physical.impl.SendingAccountor;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.record.FragmentWritableBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.WritableBatch;
import org.apache.drill.exec.rpc.BaseRpcOutcomeListener;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.data.DataTunnel;
import org.apache.drill.exec.work.ErrorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BroadcastSenderRootExec
extends BaseRootExec {
    static final Logger logger = LoggerFactory.getLogger(BroadcastSenderRootExec.class);
    private final FragmentContext context;
    private final BroadcastSender config;
    private final DataTunnel[] tunnels;
    private final ExecProtos.FragmentHandle handle;
    private volatile boolean ok;
    private final RecordBatch incoming;
    private StatusHandler statusHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean innerNext() {
        if (!this.ok) {
            this.context.fail(this.statusHandler.ex);
            return false;
        }
        RecordBatch.IterOutcome out = this.next(this.incoming);
        logger.debug("Outcome of sender next {}", (Object)out);
        switch (out) {
            case STOP: 
            case NONE: {
                for (int i = 0; i < this.tunnels.length; ++i) {
                    FragmentWritableBatch b2 = FragmentWritableBatch.getEmptyLast(this.handle.getQueryId(), this.handle.getMajorFragmentId(), this.handle.getMinorFragmentId(), this.config.getOppositeMajorFragmentId(), i);
                    this.stats.startWait();
                    try {
                        this.tunnels[i].sendRecordBatch(this.statusHandler, b2);
                    }
                    finally {
                        this.stats.stopWait();
                    }
                    this.statusHandler.sendCount.increment();
                }
                return false;
            }
            case OK_NEW_SCHEMA: 
            case OK: {
                WritableBatch writableBatch = this.incoming.getWritableBatch();
                if (this.tunnels.length > 1) {
                    writableBatch.retainBuffers(this.tunnels.length - 1);
                }
                for (int i = 0; i < this.tunnels.length; ++i) {
                    FragmentWritableBatch batch = new FragmentWritableBatch(false, this.handle.getQueryId(), this.handle.getMajorFragmentId(), this.handle.getMinorFragmentId(), this.config.getOppositeMajorFragmentId(), i, writableBatch);
                    this.updateStats(batch);
                    this.stats.startWait();
                    try {
                        this.tunnels[i].sendRecordBatch(this.statusHandler, batch);
                    }
                    finally {
                        this.stats.stopWait();
                    }
                    this.statusHandler.sendCount.increment();
                }
                return this.ok;
            }
        }
        throw new IllegalStateException();
    }

    public void updateStats(FragmentWritableBatch writableBatch) {
        this.stats.setLongStat(Metric.N_RECEIVERS, this.tunnels.length);
        this.stats.addLongStat(Metric.BYTES_SENT, writableBatch.getByteCount());
    }

    @Override
    public void stop() {
        this.ok = false;
        this.statusHandler.sendCount.waitForSendComplete();
        this.oContext.close();
        this.incoming.cleanup();
    }

    private class StatusHandler
    extends BaseRpcOutcomeListener<GeneralRPCProtos.Ack> {
        volatile RpcException ex;
        private final SendingAccountor sendCount;
        final /* synthetic */ BroadcastSenderRootExec this$0;

        @Override
        public void success(GeneralRPCProtos.Ack value, ByteBuf buffer) {
            this.sendCount.decrement();
            super.success(value, buffer);
        }

        @Override
        public void failed(RpcException ex) {
            this.sendCount.decrement();
            logger.error("Failure while sending data to user.", ex);
            ErrorHelper.logAndConvertError(this.this$0.context.getIdentity(), "Failure while sending fragment to client.", ex, logger);
            this.this$0.ok = false;
            this.ex = ex;
        }
    }

    public static enum Metric implements MetricDef
    {
        N_RECEIVERS,
        BYTES_SENT;


        @Override
        public int metricId() {
            return this.ordinal();
        }
    }
}

