/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.memory.OutOfMemoryException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.MetricDef;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.physical.config.SingleSender;
import org.apache.drill.exec.physical.impl.BaseRootExec;
import org.apache.drill.exec.physical.impl.RootCreator;
import org.apache.drill.exec.physical.impl.RootExec;
import org.apache.drill.exec.physical.impl.SendingAccountor;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.record.FragmentWritableBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.rpc.BaseRpcOutcomeListener;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.data.DataTunnel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleSenderCreator
implements RootCreator<SingleSender> {
    @Override
    public RootExec getRoot(FragmentContext context, SingleSender config, List<RecordBatch> children) throws ExecutionSetupException {
        assert (children != null && children.size() == 1);
        return new SingleSenderRootExec(context, children.iterator().next(), config);
    }

    private static class SingleSenderRootExec
    extends BaseRootExec {
        static final Logger logger = LoggerFactory.getLogger(SingleSenderRootExec.class);
        private RecordBatch incoming;
        private DataTunnel tunnel;
        private ExecProtos.FragmentHandle handle;
        private SingleSender config;
        private int recMajor;
        private FragmentContext context;
        private volatile boolean ok = true;
        private volatile boolean done = false;
        private final SendingAccountor sendCount = new SendingAccountor();

        public SingleSenderRootExec(FragmentContext context, RecordBatch batch, SingleSender config) throws OutOfMemoryException {
            super(context, new OperatorContext(config, context, null, false), config);
            this.incoming = batch;
            assert (this.incoming != null);
            this.handle = context.getHandle();
            this.config = config;
            this.recMajor = config.getOppositeMajorFragmentId();
            ExecProtos.FragmentHandle opposite = this.handle.toBuilder().setMajorFragmentId(config.getOppositeMajorFragmentId()).setMinorFragmentId(0).build();
            this.tunnel = context.getDataTunnel(config.getDestination(), opposite);
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean innerNext() {
            RecordBatch.IterOutcome out;
            if (!this.ok) {
                this.incoming.kill(false);
                return false;
            }
            if (!this.done) {
                out = this.next(this.incoming);
            } else {
                this.incoming.kill(true);
                out = RecordBatch.IterOutcome.NONE;
            }
            switch (out) {
                case STOP: 
                case NONE: {
                    FragmentWritableBatch b2 = FragmentWritableBatch.getEmptyLastWithSchema(this.handle.getQueryId(), this.handle.getMajorFragmentId(), this.handle.getMinorFragmentId(), this.recMajor, 0, this.incoming.getSchema());
                    this.sendCount.increment();
                    this.stats.startWait();
                    try {
                        this.tunnel.sendRecordBatch(new RecordSendFailure(), b2);
                    }
                    finally {
                        this.stats.stopWait();
                    }
                    return false;
                }
                case OK_NEW_SCHEMA: 
                case OK: {
                    FragmentWritableBatch batch = new FragmentWritableBatch(false, this.handle.getQueryId(), this.handle.getMajorFragmentId(), this.handle.getMinorFragmentId(), this.recMajor, 0, this.incoming.getWritableBatch());
                    this.updateStats(batch);
                    this.sendCount.increment();
                    this.stats.startWait();
                    try {
                        this.tunnel.sendRecordBatch(new RecordSendFailure(), batch);
                    }
                    finally {
                        this.stats.stopWait();
                    }
                    return true;
                }
            }
            throw new IllegalStateException();
        }

        public void updateStats(FragmentWritableBatch writableBatch) {
            this.stats.addLongStat(Metric.BYTES_SENT, writableBatch.getByteCount());
        }

        @Override
        public void stop() {
            this.ok = false;
            this.sendCount.waitForSendComplete();
            this.oContext.close();
            this.incoming.cleanup();
        }

        @Override
        public void receivingFragmentFinished(ExecProtos.FragmentHandle handle) {
            this.done = true;
        }

        private class RecordSendFailure
        extends BaseRpcOutcomeListener<GeneralRPCProtos.Ack> {
            private RecordSendFailure() {
            }

            @Override
            public void failed(RpcException ex) {
                SingleSenderRootExec.this.sendCount.decrement();
                if (!SingleSenderRootExec.this.context.isCancelled() && !SingleSenderRootExec.this.context.isFailed()) {
                    SingleSenderRootExec.this.context.fail(ex);
                }
                SingleSenderRootExec.this.done = true;
            }

            @Override
            public void success(GeneralRPCProtos.Ack value, ByteBuf buf) {
                SingleSenderRootExec.this.sendCount.decrement();
                if (value.getOk()) {
                    return;
                }
                logger.error("Downstream fragment was not accepted.  Stopping future sends.");
                SingleSenderRootExec.this.context.fail(new RpcException("A downstream fragment batch wasn't accepted.  This fragment thus fails."));
                SingleSenderRootExec.this.done = true;
            }
        }

        public static enum Metric implements MetricDef
        {
            BYTES_SENT;


            @Override
            public int metricId() {
                return this.ordinal();
            }
        }
    }
}

