/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.exec.physical.base.AbstractSingle;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.record.BatchSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="project")
public class Project
extends AbstractSingle {
    static final Logger logger = LoggerFactory.getLogger(Project.class);
    private final List<NamedExpression> exprs;

    @JsonCreator
    public Project(@JsonProperty(value="exprs") List<NamedExpression> exprs, @JsonProperty(value="child") PhysicalOperator child) {
        super(child);
        this.exprs = exprs;
    }

    public List<NamedExpression> getExprs() {
        return this.exprs;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitProject(this, value);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new Project(this.exprs, child);
    }

    @Override
    public BatchSchema.SelectionVectorMode getSVMode() {
        return this.child.getSVMode();
    }

    @Override
    public int getOperatorType() {
        return 10;
    }
}

