/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.physical.base.AbstractReceiver;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="merging-receiver")
public class MergingReceiverPOP
extends AbstractReceiver {
    static final Logger logger = LoggerFactory.getLogger(MergingReceiverPOP.class);
    private final List<CoordinationProtos.DrillbitEndpoint> senders;
    private final List<Order.Ordering> orderings;

    @JsonCreator
    public MergingReceiverPOP(@JsonProperty(value="sender-major-fragment") int oppositeMajorFragmentId, @JsonProperty(value="senders") List<CoordinationProtos.DrillbitEndpoint> senders, @JsonProperty(value="orderings") List<Order.Ordering> orderings) {
        super(oppositeMajorFragmentId);
        this.senders = senders;
        this.orderings = orderings;
    }

    @Override
    @JsonProperty(value="senders")
    public List<CoordinationProtos.DrillbitEndpoint> getProvidingEndpoints() {
        return this.senders;
    }

    @Override
    public boolean supportsOutOfOrderExchange() {
        return false;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitMergingReceiver(this, value);
    }

    public List<Order.Ordering> getOrderings() {
        return this.orderings;
    }

    @Override
    public int getOperatorType() {
        return 8;
    }

    @JsonIgnore
    public int getNumSenders() {
        return this.senders.size();
    }
}

