/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.physical.base.AbstractExchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.exec.physical.base.Sender;
import org.apache.drill.exec.physical.config.HashPartitionSender;
import org.apache.drill.exec.physical.config.MergingReceiverPOP;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="hash-to-merge-exchange")
public class HashToMergeExchange
extends AbstractExchange {
    static final Logger logger = LoggerFactory.getLogger(HashToMergeExchange.class);
    private final LogicalExpression distExpr;
    private final List<Order.Ordering> orderExprs;
    private List<CoordinationProtos.DrillbitEndpoint> senderLocations;
    private List<CoordinationProtos.DrillbitEndpoint> receiverLocations;

    @JsonCreator
    public HashToMergeExchange(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="expr") LogicalExpression expr, @JsonProperty(value="orderings") List<Order.Ordering> orderExprs) {
        super(child);
        this.distExpr = expr;
        this.orderExprs = orderExprs;
    }

    @Override
    public int getMaxSendWidth() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void setupSenders(List<CoordinationProtos.DrillbitEndpoint> senderLocations) {
        this.senderLocations = senderLocations;
    }

    @Override
    protected void setupReceivers(List<CoordinationProtos.DrillbitEndpoint> receiverLocations) {
        this.receiverLocations = receiverLocations;
    }

    @Override
    public Sender getSender(int minorFragmentId, PhysicalOperator child) {
        return new HashPartitionSender(this.receiverMajorFragmentId, child, this.distExpr, this.receiverLocations);
    }

    @Override
    public Receiver getReceiver(int minorFragmentId) {
        return new MergingReceiverPOP(this.senderMajorFragmentId, this.senderLocations, this.orderExprs);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new HashToMergeExchange(child, this.distExpr, this.orderExprs);
    }
}

