/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.physical.base.AbstractSingle;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.record.BatchSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="filter")
public class Filter
extends AbstractSingle {
    static final Logger logger = LoggerFactory.getLogger(Filter.class);
    private final LogicalExpression expr;
    private final float selectivity;

    @JsonCreator
    public Filter(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="expr") LogicalExpression expr, @JsonProperty(value="selectivity") float selectivity) {
        super(child);
        this.expr = expr;
        this.selectivity = selectivity;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitFilter(this, value);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new Filter(child, this.expr, this.selectivity);
    }

    @Override
    public BatchSchema.SelectionVectorMode getSVMode() {
        if (this.child.getSVMode().equals((Object)BatchSchema.SelectionVectorMode.FOUR_BYTE)) {
            return BatchSchema.SelectionVectorMode.FOUR_BYTE;
        }
        return BatchSchema.SelectionVectorMode.TWO_BYTE;
    }

    @Override
    public int getOperatorType() {
        return 2;
    }
}

