/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.base;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanStats {
    static final Logger logger = LoggerFactory.getLogger(ScanStats.class);
    public static final ScanStats TRIVIAL_TABLE = new ScanStats(GroupScanProperty.NO_EXACT_ROW_COUNT, 20L, 1.0f, 1.0f);
    private final long recordCount;
    private final float cpuCost;
    private final float diskCost;
    private final GroupScanProperty property;

    public ScanStats(GroupScanProperty property, long recordCount, float cpuCost, float diskCost) {
        this.recordCount = recordCount;
        this.cpuCost = cpuCost;
        this.diskCost = diskCost;
        this.property = property;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public GroupScanProperty getGroupScanProperty() {
        return this.property;
    }

    public static enum GroupScanProperty {
        NO_EXACT_ROW_COUNT(false, false),
        EXACT_ROW_COUNT(true, true);

        private boolean hasExactRowCount;
        private boolean hasExactColumnValueCount;

        private GroupScanProperty(boolean hasExactRowCount, boolean hasExactColumnValueCount) {
            this.hasExactRowCount = hasExactRowCount;
            this.hasExactColumnValueCount = hasExactColumnValueCount;
        }

        public boolean hasExactRowCount() {
            return this.hasExactRowCount;
        }

        public boolean hasExactColumnValueCount() {
            return this.hasExactColumnValueCount;
        }
    }
}

