/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSingle
extends AbstractBase {
    static final Logger logger = LoggerFactory.getLogger(AbstractSingle.class);
    protected final PhysicalOperator child;

    public AbstractSingle(PhysicalOperator child) {
        this.child = child;
    }

    @Override
    public Iterator<PhysicalOperator> iterator() {
        return Iterators.singletonIterator(this.child);
    }

    public PhysicalOperator getChild() {
        return this.child;
    }

    @Override
    @JsonIgnore
    public final PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument(children.size() == 1);
        return this.getNewWithChild(children.iterator().next());
    }

    protected abstract PhysicalOperator getNewWithChild(PhysicalOperator var1);
}

