/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.base;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.base.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReceiver
extends AbstractBase
implements Receiver {
    static final Logger logger = LoggerFactory.getLogger(AbstractReceiver.class);
    private final int oppositeMajorFragmentId;

    public AbstractReceiver(int oppositeMajorFragmentId) {
        this.oppositeMajorFragmentId = oppositeMajorFragmentId;
    }

    @Override
    public Iterator<PhysicalOperator> iterator() {
        return Iterators.emptyIterator();
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitReceiver(this, value);
    }

    @Override
    public final PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument(children.isEmpty());
        return this;
    }

    @Override
    @JsonProperty(value="sender-major-fragment")
    public int getOppositeMajorFragmentId() {
        return this.oppositeMajorFragmentId;
    }
}

