/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.drill.common.graph.Graph;
import org.apache.drill.common.graph.GraphAlgos;
import org.apache.drill.common.logical.PlanProperties;
import org.apache.drill.exec.physical.base.Leaf;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"head", "graph"})
public class PhysicalPlan {
    static final Logger logger = LoggerFactory.getLogger(PhysicalPlan.class);
    PlanProperties properties;
    Graph<PhysicalOperator, Root, Leaf> graph;

    @JsonCreator
    public PhysicalPlan(@JsonProperty(value="head") PlanProperties properties, @JsonProperty(value="graph") List<PhysicalOperator> operators) {
        this.properties = properties;
        this.graph = Graph.newGraph(operators, Root.class, Leaf.class);
    }

    @JsonProperty(value="graph")
    public List<PhysicalOperator> getSortedOperators() {
        return this.getSortedOperators(true);
    }

    public List<PhysicalOperator> getSortedOperators(boolean reverse) {
        List<PhysicalOperator> list = GraphAlgos.TopoSorter.sort(this.graph);
        if (reverse) {
            return Lists.reverse(list);
        }
        return list;
    }

    @JsonProperty(value="head")
    public PlanProperties getProperties() {
        return this.properties;
    }

    public String unparse(ObjectWriter writer) {
        try {
            return writer.writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

