/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical;

import com.google.protobuf.TextFormat;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointAffinity
implements Comparable<EndpointAffinity> {
    static final Logger logger = LoggerFactory.getLogger(EndpointAffinity.class);
    private CoordinationProtos.DrillbitEndpoint endpoint;
    private float affinity = 0.0f;

    public EndpointAffinity(CoordinationProtos.DrillbitEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public EndpointAffinity(CoordinationProtos.DrillbitEndpoint endpoint, float affinity) {
        this.endpoint = endpoint;
        this.affinity = affinity;
    }

    public CoordinationProtos.DrillbitEndpoint getEndpoint() {
        return this.endpoint;
    }

    public float getAffinity() {
        return this.affinity;
    }

    @Override
    public int compareTo(EndpointAffinity o) {
        return Float.compare(this.affinity, o.affinity);
    }

    public void addAffinity(float f) {
        this.affinity += f;
    }

    public String toString() {
        return "EndpointAffinity [endpoint=" + TextFormat.shortDebugString(this.endpoint) + ", affinity=" + this.affinity + "]";
    }
}

