/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.ops;

import java.util.Collection;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.jdbc.SimpleOptiqSchema;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.ops.Multitimer;
import org.apache.drill.exec.ops.QuerySetup;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.sql.DrillOperatorTable;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.control.WorkEventBus;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.QueryOptionManager;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryContext {
    static final Logger logger = LoggerFactory.getLogger(QueryContext.class);
    private final UserBitShared.QueryId queryId;
    private final DrillbitContext drillbitContext;
    private final WorkEventBus workBus;
    private UserSession session;
    private OptionManager queryOptions;
    public final Multitimer<QuerySetup> timer;
    private final PlannerSettings plannerSettings;
    private final DrillOperatorTable table;

    public QueryContext(UserSession session, UserBitShared.QueryId queryId, DrillbitContext drllbitContext) {
        this.queryId = queryId;
        this.drillbitContext = drllbitContext;
        this.workBus = drllbitContext.getWorkBus();
        this.session = session;
        this.timer = new Multitimer<QuerySetup>(QuerySetup.class);
        this.queryOptions = new QueryOptionManager(session.getOptions());
        this.plannerSettings = new PlannerSettings(this.queryOptions, this.getFunctionRegistry());
        this.plannerSettings.setNumEndPoints(this.getActiveEndpoints().size());
        this.table = new DrillOperatorTable(this.getFunctionRegistry());
    }

    public PlannerSettings getPlannerSettings() {
        return this.plannerSettings;
    }

    public UserSession getSession() {
        return this.session;
    }

    public SchemaPlus getNewDefaultSchema() {
        SchemaPlus rootSchema = this.getRootSchema();
        SchemaPlus defaultSchema = this.session.getDefaultSchema(rootSchema);
        if (defaultSchema == null) {
            return rootSchema;
        }
        return defaultSchema;
    }

    public SchemaPlus getRootSchema() {
        SchemaPlus rootSchema = SimpleOptiqSchema.createRootSchema(false);
        this.drillbitContext.getSchemaFactory().registerSchemas(this.session, rootSchema);
        return rootSchema;
    }

    public OptionManager getOptions() {
        return this.queryOptions;
    }

    public CoordinationProtos.DrillbitEndpoint getCurrentEndpoint() {
        return this.drillbitContext.getEndpoint();
    }

    public StoragePluginRegistry getStorage() {
        return this.drillbitContext.getStorage();
    }

    public Collection<CoordinationProtos.DrillbitEndpoint> getActiveEndpoints() {
        return this.drillbitContext.getBits();
    }

    public PhysicalPlanReader getPlanReader() {
        return this.drillbitContext.getPlanReader();
    }

    public DrillConfig getConfig() {
        return this.drillbitContext.getConfig();
    }

    public WorkEventBus getWorkBus() {
        return this.workBus;
    }

    public FunctionImplementationRegistry getFunctionRegistry() {
        return this.drillbitContext.getFunctionImplementationRegistry();
    }

    public DrillOperatorTable getDrillOperatorTable() {
        return this.table;
    }

    public ClusterCoordinator getClusterCoordinator() {
        return this.drillbitContext.getClusterCoordinator();
    }
}

