/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.ops;

import com.carrotsearch.hppc.LongObjectOpenHashMap;
import io.netty.buffer.DrillBuf;
import java.util.Iterator;
import org.apache.drill.common.util.Hook;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OperatorStats;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorContext
implements Hook.Closeable {
    static final Logger logger = LoggerFactory.getLogger(OperatorContext.class);
    private final BufferAllocator allocator;
    private boolean closed = false;
    private PhysicalOperator popConfig;
    private OperatorStats stats;
    private LongObjectOpenHashMap<DrillBuf> managedBuffers = new LongObjectOpenHashMap();
    private final boolean applyFragmentLimit;

    public OperatorContext(PhysicalOperator popConfig, FragmentContext context, OperatorStats stats, boolean applyFragmentLimit) throws OutOfMemoryException {
        this.applyFragmentLimit = applyFragmentLimit;
        this.allocator = context.getNewChildAllocator(popConfig.getInitialAllocation(), popConfig.getMaxAllocation(), applyFragmentLimit);
        this.popConfig = popConfig;
        this.stats = stats;
    }

    public DrillBuf replace(DrillBuf old, int newSize) {
        if (this.managedBuffers.remove(old.memoryAddress()) == null) {
            throw new IllegalStateException("Tried to remove unmanaged buffer.");
        }
        old.release();
        return this.getManagedBuffer(newSize);
    }

    public DrillBuf getManagedBuffer(int size) {
        DrillBuf newBuf = this.allocator.buffer(size);
        this.managedBuffers.put(newBuf.memoryAddress(), newBuf);
        newBuf.setOperatorContext(this);
        return newBuf;
    }

    public static int getChildCount(PhysicalOperator popConfig) {
        Iterator iter = popConfig.iterator();
        int i = 0;
        while (iter.hasNext()) {
            iter.next();
            ++i;
        }
        if (i == 0) {
            i = 1;
        }
        return i;
    }

    public BufferAllocator getAllocator() {
        if (this.allocator == null) {
            throw new UnsupportedOperationException("Operator context does not have an allocator");
        }
        return this.allocator;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (this.closed) {
            logger.debug("Attempted to close Operator context for {}, but context is already closed", (Object)(this.popConfig != null ? this.popConfig.getClass().getName() : null));
            return;
        }
        logger.debug("Closing context for {}", (Object)(this.popConfig != null ? this.popConfig.getClass().getName() : null));
        Object[] buffers = this.managedBuffers.values;
        for (int i = 0; i < buffers.length; ++i) {
            if (!this.managedBuffers.allocated[i]) continue;
            ((DrillBuf)buffers[i]).release();
        }
        if (this.allocator != null) {
            this.allocator.close();
        }
        this.closed = true;
    }
}

