/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.ops;

import com.carrotsearch.hppc.LongObjectOpenHashMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.DrillBuf;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.compile.QueryClassLoader;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.memory.OutOfMemoryException;
import org.apache.drill.exec.ops.FragmentStats;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.control.ControlTunnel;
import org.apache.drill.exec.rpc.data.DataTunnel;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.server.options.FragmentOptionManager;
import org.apache.drill.exec.server.options.OptionList;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.work.batch.IncomingBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentContext
implements Closeable {
    static final Logger logger = LoggerFactory.getLogger(FragmentContext.class);
    private Map<ExecProtos.FragmentHandle, DataTunnel> tunnels = Maps.newHashMap();
    private final DrillbitContext context;
    private final UserServer.UserClientConnection connection;
    private final FragmentStats stats;
    private final FunctionImplementationRegistry funcRegistry;
    private final QueryClassLoader loader;
    private final BufferAllocator allocator;
    private final BitControl.PlanFragment fragment;
    private List<Thread> daemonThreads = Lists.newLinkedList();
    private IncomingBuffers buffers;
    private final long queryStartTime;
    private final int rootFragmentTimeZone;
    private final OptionManager fragmentOptions;
    private final UserBitShared.UserCredentials credentials;
    private LongObjectOpenHashMap<DrillBuf> managedBuffers = new LongObjectOpenHashMap();
    private volatile Throwable failureCause;
    private volatile FragmentContextState state = FragmentContextState.OK;

    public FragmentContext(DrillbitContext dbContext, BitControl.PlanFragment fragment, UserServer.UserClientConnection connection, FunctionImplementationRegistry funcRegistry) throws OutOfMemoryException, ExecutionSetupException {
        this.stats = new FragmentStats(dbContext.getMetrics(), fragment.getAssignment());
        this.context = dbContext;
        this.connection = connection;
        this.fragment = fragment;
        this.funcRegistry = funcRegistry;
        this.queryStartTime = fragment.getQueryStartTime();
        this.rootFragmentTimeZone = fragment.getTimeZone();
        this.credentials = fragment.getCredentials();
        logger.debug("Getting initial memory allocation of {}", (Object)fragment.getMemInitial());
        logger.debug("Fragment max allocation: {}", (Object)fragment.getMemMax());
        try {
            OptionList list = !fragment.hasOptionsJson() || fragment.getOptionsJson().isEmpty() ? new OptionList() : dbContext.getConfig().getMapper().readValue(fragment.getOptionsJson(), OptionList.class);
            this.fragmentOptions = new FragmentOptionManager((OptionManager)this.context.getOptionManager(), list);
        }
        catch (Exception e) {
            throw new ExecutionSetupException("Failure while reading plan options.", e);
        }
        try {
            this.allocator = this.context.getAllocator().getChildAllocator(this, fragment.getMemInitial(), fragment.getMemMax(), true);
            assert (this.allocator != null);
        }
        catch (Throwable e) {
            throw new ExecutionSetupException("Failure while getting memory allocator for fragment.", e);
        }
        this.loader = new QueryClassLoader(dbContext.getConfig(), this.fragmentOptions);
    }

    public OptionManager getOptions() {
        return this.fragmentOptions;
    }

    public void setBuffers(IncomingBuffers buffers) {
        this.buffers = buffers;
    }

    public void fail(Throwable cause) {
        logger.error("Fragment Context received failure.", cause);
        this.setState(FragmentContextState.FAILED);
        this.failureCause = cause;
    }

    public void cancel() {
        this.setState(FragmentContextState.CANCELED);
    }

    private synchronized void setState(FragmentContextState newState) {
        if (this.state == FragmentContextState.OK) {
            this.state = newState;
        } else if (newState == FragmentContextState.CANCELED) {
            this.state = newState;
        }
    }

    public DrillbitContext getDrillbitContext() {
        return this.context;
    }

    public CoordinationProtos.DrillbitEndpoint getIdentity() {
        return this.context.getEndpoint();
    }

    public FragmentStats getStats() {
        return this.stats;
    }

    public CoordinationProtos.DrillbitEndpoint getForemanEndpoint() {
        return this.fragment.getForeman();
    }

    public ExecProtos.FragmentHandle getHandle() {
        return this.fragment.getHandle();
    }

    @Deprecated
    public BufferAllocator getAllocator() {
        if (this.allocator == null) {
            ExecProtos.FragmentHandle handle = this.getHandle();
            String frag = handle != null ? handle.getMajorFragmentId() + ":" + handle.getMinorFragmentId() : "0:0";
            logger.debug("Fragment:" + frag + " Allocator is NULL");
        }
        return this.allocator;
    }

    public BufferAllocator getNewChildAllocator(long initialReservation, long maximumReservation, boolean applyFragmentLimit) throws OutOfMemoryException {
        return this.allocator.getChildAllocator(this, initialReservation, maximumReservation, applyFragmentLimit);
    }

    public <T> T getImplementationClass(ClassGenerator<T> cg) throws ClassTransformationException, IOException {
        return this.getImplementationClass(cg.getCodeGenerator());
    }

    public <T> T getImplementationClass(CodeGenerator<T> cg) throws ClassTransformationException, IOException {
        return this.context.getCompiler().getImplementationClass(cg);
    }

    public UserServer.UserClientConnection getConnection() {
        return this.connection;
    }

    public ControlTunnel getControlTunnel(CoordinationProtos.DrillbitEndpoint endpoint) {
        return this.context.getController().getTunnel(endpoint);
    }

    public DataTunnel getDataTunnel(CoordinationProtos.DrillbitEndpoint endpoint, ExecProtos.FragmentHandle remoteHandle) {
        DataTunnel tunnel = this.tunnels.get(remoteHandle);
        if (tunnel == null) {
            tunnel = this.context.getDataConnectionsPool().getTunnel(endpoint, remoteHandle);
            this.tunnels.put(remoteHandle, tunnel);
        }
        return tunnel;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public boolean isFailed() {
        return this.state == FragmentContextState.FAILED;
    }

    public boolean isCancelled() {
        return this.state == FragmentContextState.CANCELED;
    }

    public FunctionImplementationRegistry getFunctionRegistry() {
        return this.funcRegistry;
    }

    public DrillConfig getConfig() {
        return this.context.getConfig();
    }

    public void setFragmentLimit(long limit) {
        this.allocator.setFragmentLimit(limit);
    }

    @Override
    public void close() {
        ExecProtos.FragmentHandle handle;
        for (Thread thread : this.daemonThreads) {
            thread.interrupt();
        }
        Object[] mbuffers = this.managedBuffers.values;
        for (int i = 0; i < mbuffers.length; ++i) {
            if (!this.managedBuffers.allocated[i]) continue;
            ((DrillBuf)mbuffers[i]).release();
        }
        if (this.buffers != null) {
            this.buffers.close();
        }
        String frag = (handle = this.getHandle()) != null ? handle.getMajorFragmentId() + ":" + handle.getMinorFragmentId() : "0:0";
        this.allocator.close();
        logger.debug("Fragment:" + frag + " After close allocator is: " + this.allocator != null ? "OK" : "NULL");
    }

    public DrillBuf replace(DrillBuf old, int newSize) {
        if (this.managedBuffers.remove(old.memoryAddress()) == null) {
            throw new IllegalStateException("Tried to remove unmanaged buffer.");
        }
        old.release();
        return this.getManagedBuffer(newSize);
    }

    public DrillBuf getManagedBuffer() {
        return this.getManagedBuffer(256);
    }

    public DrillBuf getManagedBuffer(int size) {
        DrillBuf newBuf = this.allocator.buffer(size);
        this.managedBuffers.put(newBuf.memoryAddress(), newBuf);
        newBuf.setFragmentContext(this);
        return newBuf;
    }

    private static enum FragmentContextState {
        OK,
        FAILED,
        CANCELED;

    }
}

