/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.memory;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.memory.AtomicRemainder;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.helper.QueryIdHelper;
import org.apache.drill.exec.util.AssertionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Accountor {
    static final Logger logger = LoggerFactory.getLogger(Accountor.class);
    private static final boolean ENABLE_ACCOUNTING = AssertionUtil.isAssertionsEnabled();
    private final AtomicRemainder remainder;
    private final long total;
    private ConcurrentMap<ByteBuf, DebugStackTrace> buffers = Maps.newConcurrentMap();
    private final ExecProtos.FragmentHandle handle;
    private String fragmentStr;
    private Accountor parent;
    private final boolean errorOnLeak;
    private final boolean enableFragmentLimit;
    private final double fragmentMemOvercommitFactor;
    private final boolean DEFAULT_ENABLE_FRAGMENT_LIMIT = false;
    private final double DEFAULT_FRAGMENT_MEM_OVERCOMMIT_FACTOR = 1.5;
    private final boolean applyFragmentLimit;
    private final FragmentContext fragmentContext;
    long fragmentLimit;
    private final List<FragmentContext> fragmentContexts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Accountor(DrillConfig config, boolean errorOnLeak, FragmentContext context, Accountor parent, long max, long preAllocated, boolean applyFragLimit) {
        double fragmentMemOvercommitFactor;
        boolean enableFragmentLimit;
        this.errorOnLeak = errorOnLeak;
        AtomicRemainder parentRemainder = parent != null ? parent.remainder : null;
        this.parent = parent;
        try {
            enableFragmentLimit = config.getBoolean("drill.exec.memory.enable_frag_limit");
            fragmentMemOvercommitFactor = config.getDouble("drill.exec.memory.frag_mem_overcommit_factor");
        }
        catch (Exception e) {
            enableFragmentLimit = false;
            fragmentMemOvercommitFactor = 1.5;
        }
        this.enableFragmentLimit = enableFragmentLimit;
        this.fragmentMemOvercommitFactor = fragmentMemOvercommitFactor;
        this.applyFragmentLimit = applyFragLimit;
        this.remainder = new AtomicRemainder(errorOnLeak, parentRemainder, max, preAllocated, this.applyFragmentLimit);
        this.total = max;
        this.fragmentContext = context;
        this.handle = context != null ? context.getHandle() : null;
        this.fragmentStr = this.handle != null ? this.handle.getMajorFragmentId() + ":" + this.handle.getMinorFragmentId() : "0:0";
        this.fragmentLimit = this.total;
        this.buffers = ENABLE_ACCOUNTING ? Maps.newConcurrentMap() : null;
        this.fragmentContexts = new ArrayList<FragmentContext>();
        if (parent != null && parent.parent == null) {
            Accountor accountor = this;
            synchronized (accountor) {
                this.addFragmentContext(this.fragmentContext);
            }
        }
    }

    public boolean transferTo(Accountor target, DrillBuf buf, long size) {
        boolean withinLimit = target.forceAdditionalReservation(size);
        this.release(buf, size);
        if (ENABLE_ACCOUNTING) {
            target.buffers.put(buf, new DebugStackTrace(buf.capacity(), Thread.currentThread().getStackTrace()));
        }
        return withinLimit;
    }

    public long getAvailable() {
        if (this.parent != null) {
            return Math.min(this.parent.getAvailable(), this.getCapacity() - this.getAllocation());
        }
        return this.getCapacity() - this.getAllocation();
    }

    public long getCapacity() {
        return this.fragmentLimit;
    }

    public long getAllocation() {
        return this.remainder.getUsed();
    }

    public boolean reserve(long size) {
        logger.trace("Fragment:" + this.fragmentStr + " Reserved " + size + " bytes. Total Allocated: " + this.getAllocation());
        return this.remainder.get(size, this.applyFragmentLimit);
    }

    public boolean forceAdditionalReservation(long size) {
        if (size > 0L) {
            return this.remainder.forceGet(size);
        }
        return true;
    }

    public void reserved(long expected, DrillBuf buf) {
        long additional = (long)buf.capacity() - expected;
        if (additional > 0L) {
            this.remainder.forceGet(additional);
        }
        if (ENABLE_ACCOUNTING) {
            this.buffers.put(buf, new DebugStackTrace(buf.capacity(), Thread.currentThread().getStackTrace()));
        }
    }

    public void releasePartial(DrillBuf buf, long size) {
        this.remainder.returnAllocation(size);
        if (ENABLE_ACCOUNTING && buf != null) {
            DebugStackTrace dst = (DebugStackTrace)this.buffers.get(buf);
            if (dst == null) {
                throw new IllegalStateException("Partially releasing a buffer that has already been released. Buffer: " + buf);
            }
            dst.size -= size;
            if (dst.size < 0L) {
                throw new IllegalStateException("Partially releasing a buffer that has already been released. Buffer: " + buf);
            }
        }
    }

    public void release(DrillBuf buf, long size) {
        this.remainder.returnAllocation(size);
        if (ENABLE_ACCOUNTING && buf != null && this.buffers.remove(buf) == null) {
            throw new IllegalStateException("Releasing a buffer that has already been released. Buffer: " + buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFragmentContext(FragmentContext c) {
        if (this.parent != null) {
            this.parent.addFragmentContext(c);
        } else {
            if (logger.isTraceEnabled()) {
                ExecProtos.FragmentHandle hndle;
                String fragStr = c != null ? ((hndle = c.getHandle()) != null ? hndle.getMajorFragmentId() + ":" + hndle.getMinorFragmentId() : "[Null Fragment Handle]") : "[Null Context]";
                fragStr = fragStr + " (Object Id: " + System.identityHashCode(c) + ")";
                StackTraceElement[] ste = new Throwable().getStackTrace();
                StringBuffer sb = new StringBuffer();
                for (StackTraceElement s : ste) {
                    sb.append(s.toString());
                    sb.append("\n");
                }
                logger.trace("Fragment " + fragStr + " added to root accountor.\n" + sb.toString());
            }
            Accountor accountor = this;
            synchronized (accountor) {
                this.fragmentContexts.add(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFragmentContext(FragmentContext c) {
        if (this.parent != null) {
            if (this.parent.parent == null) {
                this.parent.removeFragmentContext(c);
            }
        } else {
            if (logger.isDebugEnabled()) {
                ExecProtos.FragmentHandle hndle;
                String fragStr = c != null ? ((hndle = c.getHandle()) != null ? hndle.getMajorFragmentId() + ":" + hndle.getMinorFragmentId() : "[Null Fragment Handle]") : "[Null Context]";
                fragStr = fragStr + " (Object Id: " + System.identityHashCode(c) + ")";
                logger.trace("Fragment " + fragStr + " removed from root accountor");
            }
            Accountor accountor = this;
            synchronized (accountor) {
                this.fragmentContexts.remove(c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long resetFragmentLimits() {
        if (!this.enableFragmentLimit) {
            return this.getCapacity();
        }
        if (this.parent != null) {
            this.parent.resetFragmentLimits();
        } else {
            Accountor accountor = this;
            synchronized (accountor) {
                int nFragments = this.fragmentContexts.size();
                long allocatedMemory = 0L;
                for (FragmentContext fragment : this.fragmentContexts) {
                    BufferAllocator a = fragment.getAllocator();
                    if (a == null) continue;
                    allocatedMemory += fragment.getAllocator().getAllocatedMemory();
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Resetting Fragment Memory Limit: total Available memory== " + this.total + " Total Allocated Memory :" + allocatedMemory + " Number of fragments: " + nFragments + " fragmentMemOvercommitFactor: " + this.fragmentMemOvercommitFactor + " Root fragment limit: " + this.fragmentLimit + "(Root obj: " + System.identityHashCode(this) + ")");
                }
                if (nFragments > 0) {
                    long rem = (this.total - allocatedMemory) / (long)nFragments;
                    for (FragmentContext fragment : this.fragmentContexts) {
                        fragment.setFragmentLimit((long)((double)rem * this.fragmentMemOvercommitFactor));
                    }
                }
                if (logger.isTraceEnabled()) {
                    // empty if block
                }
            }
        }
        return this.getCapacity();
    }

    public void close() {
        if (this.parent != null && this.parent.parent == null) {
            logger.debug("Fragment " + this.fragmentStr + "  accountor being closed");
            this.removeFragmentContext(this.fragmentContext);
        }
        this.resetFragmentLimits();
        if (ENABLE_ACCOUNTING && !this.buffers.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            sb.append("Attempted to close accountor with ");
            sb.append(this.buffers.size());
            sb.append(" buffer(s) still allocated");
            if (this.handle != null) {
                sb.append("for QueryId: ");
                sb.append(QueryIdHelper.getQueryId(this.handle.getQueryId()));
                sb.append(", MajorFragmentId: ");
                sb.append(this.handle.getMajorFragmentId());
                sb.append(", MinorFragmentId: ");
                sb.append(this.handle.getMinorFragmentId());
            }
            sb.append(".\n");
            LinkedListMultimap multi = LinkedListMultimap.create();
            for (DebugStackTrace t : this.buffers.values()) {
                multi.put(t, t);
            }
            for (DebugStackTrace entry : multi.keySet()) {
                Collection allocs = multi.get(entry);
                sb.append("\n\n\tTotal ");
                sb.append(allocs.size());
                sb.append(" allocation(s) of byte size(s): ");
                for (DebugStackTrace alloc : allocs) {
                    sb.append(alloc.size);
                    sb.append(", ");
                }
                sb.append("at stack location:\n");
                entry.addToString(sb);
            }
            if (!this.buffers.isEmpty()) {
                IllegalStateException e = new IllegalStateException(sb.toString());
                if (this.errorOnLeak) {
                    throw e;
                }
                logger.warn("Memory leaked.", e);
            }
        }
        this.remainder.close();
    }

    public void setFragmentLimit(long add) {
        if (this.parent != null && this.parent.parent == null) {
            this.fragmentLimit = this.getAllocation() + add;
            this.remainder.setLimit(this.fragmentLimit);
            logger.trace("Fragment " + this.fragmentStr + " memory limit set to " + this.fragmentLimit);
        }
    }

    public class DebugStackTrace {
        private StackTraceElement[] elements;
        private long size;

        public DebugStackTrace(long size, StackTraceElement[] elements) {
            this.elements = elements;
            this.size = size;
        }

        public void addToString(StringBuffer sb) {
            for (int i = 3; i < this.elements.length; ++i) {
                sb.append("\t\t");
                sb.append(this.elements[i]);
                sb.append("\n");
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.elements);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DebugStackTrace other = (DebugStackTrace)obj;
            return Arrays.equals(this.elements, other.elements);
        }
    }
}

