/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn.interpreter;

import com.google.common.base.Preconditions;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.BooleanOperator;
import org.apache.drill.common.expression.FunctionHolderExpression;
import org.apache.drill.common.expression.IfExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.expression.visitors.AbstractExprVisitor;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.DrillFuncHolderExpr;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.expr.ValueVectorReadExpression;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.fn.DrillSimpleFuncHolder;
import org.apache.drill.exec.expr.fn.interpreter.DrillSimpleFuncInterpreter;
import org.apache.drill.exec.expr.holders.BitHolder;
import org.apache.drill.exec.expr.holders.NullableBitHolder;
import org.apache.drill.exec.expr.holders.ValueHolder;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.vector.ValueHolderHelper;
import org.apache.drill.exec.vector.ValueVector;

public class InterpreterEvaluator {

    public static class InterEvalVisitor
    extends AbstractExprVisitor<ValueHolder, Integer, RuntimeException> {
        private RecordBatch incoming;

        @Override
        public ValueHolder visitFunctionHolderExpression(FunctionHolderExpression holderExpr, Integer inIndex) {
            if (!(holderExpr.getHolder() instanceof DrillSimpleFuncHolder)) {
                throw new UnsupportedOperationException("Only Drill simple UDF can be used in interpreter mode!");
            }
            DrillSimpleFuncHolder holder = (DrillSimpleFuncHolder)holderExpr.getHolder();
            ValueHolder[] args = new ValueHolder[holderExpr.args.size()];
            for (int i = 0; i < holderExpr.args.size(); ++i) {
                args[i] = ((LogicalExpression)holderExpr.args.get(i)).accept(this, inIndex);
                if (holder.getNullHandling() != FunctionTemplate.NullHandling.NULL_IF_NULL) continue;
                if (holder.getParameters()[i].getType().getMode() == TypeProtos.DataMode.REQUIRED && TypeHelper.getValueHolderType(args[i]).getMode() == TypeProtos.DataMode.OPTIONAL) {
                    if (TypeHelper.isNull(args[i])) {
                        return TypeHelper.createValueHolder(holderExpr.getMajorType());
                    }
                    args[i] = TypeHelper.deNullify(args[i]);
                    continue;
                }
                if (holder.getParameters()[i].getType().getMode() != TypeProtos.DataMode.OPTIONAL || TypeHelper.getValueHolderType(args[i]).getMode() != TypeProtos.DataMode.REQUIRED) continue;
                args[i] = TypeHelper.nullify(args[i]);
            }
            try {
                DrillSimpleFuncInterpreter interpreter = ((DrillFuncHolderExpr)holderExpr).getInterpreter();
                Preconditions.checkArgument(interpreter != null, "interpreter could not be null when use interpreted model to evaluate function " + holder.getRegisteredNames()[0]);
                interpreter.doSetup(args, this.incoming);
                ValueHolder out = interpreter.doEval(args);
                if (TypeHelper.getValueHolderType(out).getMode() == TypeProtos.DataMode.OPTIONAL && holderExpr.getMajorType().getMode() == TypeProtos.DataMode.REQUIRED) {
                    return TypeHelper.deNullify(out);
                }
                if (TypeHelper.getValueHolderType(out).getMode() == TypeProtos.DataMode.REQUIRED && holderExpr.getMajorType().getMode() == TypeProtos.DataMode.OPTIONAL) {
                    return TypeHelper.nullify(out);
                }
                return out;
            }
            catch (Exception ex) {
                throw new RuntimeException("Error in evaluating function of " + holderExpr.getName() + ": " + ex);
            }
        }

        @Override
        public ValueHolder visitBooleanOperator(BooleanOperator op, Integer inIndex) {
            if (op.getName().equals("booleanAnd")) {
                return this.visitBooleanAnd(op, inIndex);
            }
            if (op.getName().equals("booleanOr")) {
                return this.visitBooleanOr(op, inIndex);
            }
            throw new UnsupportedOperationException("BooleanOperator can only be booleanAnd, booleanOr. You are using " + op.getName());
        }

        @Override
        public ValueHolder visitIfExpression(IfExpression ifExpr, Integer inIndex) throws RuntimeException {
            ValueHolder condHolder = ifExpr.ifCondition.condition.accept(this, inIndex);
            assert (condHolder instanceof BitHolder || condHolder instanceof NullableBitHolder);
            Trivalent flag = this.isBitOn(condHolder);
            switch (flag) {
                case TRUE: {
                    return ifExpr.ifCondition.expression.accept(this, inIndex);
                }
                case FALSE: 
                case NULL: {
                    return ifExpr.elseExpression.accept(this, inIndex);
                }
            }
            throw new UnsupportedOperationException("No other possible choice. Something is not right");
        }

        @Override
        public ValueHolder visitIntConstant(ValueExpressions.IntExpression e, Integer inIndex) throws RuntimeException {
            return ValueHolderHelper.getIntHolder(e.getInt());
        }

        @Override
        public ValueHolder visitLongConstant(ValueExpressions.LongExpression intExpr, Integer value) throws RuntimeException {
            return ValueHolderHelper.getBigIntHolder(intExpr.getLong());
        }

        @Override
        public ValueHolder visitDoubleConstant(ValueExpressions.DoubleExpression dExpr, Integer value) throws RuntimeException {
            return ValueHolderHelper.getFloat8Holder(dExpr.getDouble());
        }

        @Override
        public ValueHolder visitQuotedStringConstant(ValueExpressions.QuotedString e, Integer value) throws RuntimeException {
            return ValueHolderHelper.getVarCharHolder(this.incoming.getContext().getManagedBuffer(), (String)e.value);
        }

        @Override
        public ValueHolder visitUnknown(LogicalExpression e, Integer inIndex) throws RuntimeException {
            if (e instanceof ValueVectorReadExpression) {
                return this.visitValueVectorReadExpression((ValueVectorReadExpression)e, inIndex);
            }
            return (ValueHolder)super.visitUnknown(e, inIndex);
        }

        protected ValueHolder visitValueVectorReadExpression(ValueVectorReadExpression e, Integer inIndex) throws RuntimeException {
            TypeProtos.MajorType type = e.getMajorType();
            try {
                switch (type.getMode()) {
                    case OPTIONAL: 
                    case REQUIRED: {
                        ValueVector vv = this.incoming.getValueAccessorById(TypeHelper.getValueVectorClass(type.getMinorType(), type.getMode()), e.getFieldId().getFieldIds()).getValueVector();
                        ValueHolder holder = TypeHelper.getValue(vv, inIndex);
                        return holder;
                    }
                }
                throw new UnsupportedOperationException("Type of " + type + " is not supported yet!");
            }
            catch (Exception ex) {
                throw new DrillRuntimeException("Error when evaluate a ValueVectorReadExpression: " + ex);
            }
        }

        private ValueHolder visitBooleanAnd(BooleanOperator op, Integer inIndex) {
            ValueHolder[] args = new ValueHolder[op.args.size()];
            boolean hasNull = false;
            Object out = null;
            for (int i = 0; i < op.args.size(); ++i) {
                args[i] = ((LogicalExpression)op.args.get(i)).accept(this, inIndex);
                Trivalent flag = this.isBitOn(args[i]);
                switch (flag) {
                    case FALSE: {
                        return op.getMajorType().getMode() == TypeProtos.DataMode.OPTIONAL ? TypeHelper.nullify(ValueHolderHelper.getBitHolder(0)) : ValueHolderHelper.getBitHolder(0);
                    }
                    case NULL: {
                        hasNull = true;
                    }
                }
            }
            if (hasNull) {
                return ValueHolderHelper.getNullableBitHolder(true, 0);
            }
            return op.getMajorType().getMode() == TypeProtos.DataMode.OPTIONAL ? TypeHelper.nullify(ValueHolderHelper.getBitHolder(1)) : ValueHolderHelper.getBitHolder(1);
        }

        private ValueHolder visitBooleanOr(BooleanOperator op, Integer inIndex) {
            ValueHolder[] args = new ValueHolder[op.args.size()];
            boolean hasNull = false;
            Object out = null;
            for (int i = 0; i < op.args.size(); ++i) {
                args[i] = ((LogicalExpression)op.args.get(i)).accept(this, inIndex);
                Trivalent flag = this.isBitOn(args[i]);
                switch (flag) {
                    case TRUE: {
                        return op.getMajorType().getMode() == TypeProtos.DataMode.OPTIONAL ? TypeHelper.nullify(ValueHolderHelper.getBitHolder(1)) : ValueHolderHelper.getBitHolder(1);
                    }
                    case NULL: {
                        hasNull = true;
                    }
                }
            }
            if (hasNull) {
                return ValueHolderHelper.getNullableBitHolder(true, 0);
            }
            return op.getMajorType().getMode() == TypeProtos.DataMode.OPTIONAL ? TypeHelper.nullify(ValueHolderHelper.getBitHolder(0)) : ValueHolderHelper.getBitHolder(0);
        }

        private Trivalent isBitOn(ValueHolder holder) {
            assert (holder instanceof BitHolder || holder instanceof NullableBitHolder);
            if (holder instanceof BitHolder && ((BitHolder)holder).value == 1) {
                return Trivalent.TRUE;
            }
            if (holder instanceof NullableBitHolder && ((NullableBitHolder)holder).isSet == 1 && ((NullableBitHolder)holder).value == 1) {
                return Trivalent.TRUE;
            }
            if (holder instanceof NullableBitHolder && ((NullableBitHolder)holder).isSet == 0) {
                return Trivalent.NULL;
            }
            return Trivalent.FALSE;
        }

        public static enum Trivalent {
            FALSE,
            TRUE,
            NULL;

        }
    }
}

