/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import java.io.Writer;
import java.util.List;
import org.codehaus.janino.Java;
import org.codehaus.janino.UnparseVisitor;

public class ModifiedUnparseVisitor
extends UnparseVisitor {
    private String returnLabel;

    public ModifiedUnparseVisitor(Writer w) {
        super(w);
    }

    @Override
    public void visitMethodDeclarator(Java.MethodDeclarator md) {
        if (md.optionalStatements == null) {
            this.pw.print(';');
        } else if (md.optionalStatements.isEmpty()) {
            this.pw.print(" {}");
        } else {
            this.pw.println(' ');
            String[] fQCN = md.getDeclaringType().getClassName().split("\\.");
            this.returnLabel = fQCN[fQCN.length - 1] + "_" + md.name;
            this.pw.println(this.returnLabel + ": {");
            this.pw.print('\ufffd');
            this.unparseStatements(md.optionalStatements);
            this.pw.print('\ufffc');
            this.pw.println("}");
            this.pw.print(' ');
        }
    }

    @Override
    public void visitReturnStatement(Java.ReturnStatement rs) {
        this.pw.print("break " + this.returnLabel);
        if (rs.optionalReturnValue != null) {
            this.pw.print(' ');
            this.unparse(rs.optionalReturnValue);
        }
        this.pw.print(';');
    }

    private void unparseStatements(List<? extends Java.BlockStatement> statements) {
        int state = -1;
        for (Java.BlockStatement blockStatement : statements) {
            int x;
            int n = blockStatement instanceof Java.Block ? 1 : (blockStatement instanceof Java.LocalClassDeclarationStatement ? 2 : (blockStatement instanceof Java.LocalVariableDeclarationStatement ? 3 : (x = blockStatement instanceof Java.SynchronizedStatement ? 4 : 99)));
            if (state != -1 && state != x) {
                this.pw.println('\ufffe');
            }
            state = x;
            this.unparseBlockStatement(blockStatement);
            this.pw.println();
        }
    }

    private void unparseBlockStatement(Java.BlockStatement blockStatement) {
        blockStatement.accept(this);
    }

    private void unparse(Java.Atom operand) {
        operand.accept(this);
    }
}

