/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import com.google.common.collect.Lists;
import java.util.List;
import org.codehaus.janino.Java;
import org.codehaus.janino.util.Traverser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportGrabber {
    static final Logger logger = LoggerFactory.getLogger(ImportGrabber.class);
    private List<String> imports = Lists.newArrayList();
    private final ImportFinder finder = new ImportFinder();

    private ImportGrabber() {
    }

    public static List<String> getMethods(Java.CompilationUnit cu) {
        ImportGrabber visitor = new ImportGrabber();
        cu.getPackageMemberTypeDeclarations()[0].accept(visitor.finder.comprehensiveVisitor());
        return visitor.imports;
    }

    public class ImportFinder
    extends Traverser {
        @Override
        public void traverseSingleTypeImportDeclaration(Java.CompilationUnit.SingleTypeImportDeclaration stid) {
            ImportGrabber.this.imports.add(stid.toString());
        }

        @Override
        public void traverseSingleStaticImportDeclaration(Java.CompilationUnit.SingleStaticImportDeclaration stid) {
            ImportGrabber.this.imports.add(stid.toString());
        }

        @Override
        public void traverseTypeImportOnDemandDeclaration(Java.CompilationUnit.TypeImportOnDemandDeclaration tiodd) {
            ImportGrabber.this.imports.add(tiodd.toString());
        }

        @Override
        public void traverseStaticImportOnDemandDeclaration(Java.CompilationUnit.StaticImportOnDemandDeclaration siodd) {
            ImportGrabber.this.imports.add(siodd.toString());
        }
    }
}

