/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import java.util.ArrayList;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FunctionHolderExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.HoldingContainerExpression;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;

public class FunctionGenerationHelper {
    public static FunctionHolderExpression getComparator(ClassGenerator.HoldingContainer left, ClassGenerator.HoldingContainer right, FunctionImplementationRegistry registry) {
        return FunctionGenerationHelper.getFunctionExpression("compare_to", Types.required(TypeProtos.MinorType.INT), registry, left, right);
    }

    public static FunctionHolderExpression getFunctionExpression(String name, TypeProtos.MajorType returnType, FunctionImplementationRegistry registry, ClassGenerator.HoldingContainer ... args) {
        ArrayList<TypeProtos.MajorType> argTypes = new ArrayList<TypeProtos.MajorType>(args.length);
        ArrayList<LogicalExpression> argExpressions = new ArrayList<LogicalExpression>(args.length);
        for (ClassGenerator.HoldingContainer c : args) {
            argTypes.add(c.getMajorType());
            argExpressions.add(new HoldingContainerExpression(c));
        }
        DrillFuncHolder holder = registry.findExactMatchingDrillFunction(name, argTypes, returnType);
        if (holder != null) {
            return holder.getExpr(name, argExpressions, ExpressionPosition.UNKNOWN);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Failure finding function that runtime code generation expected.  Signature: ");
        sb.append(name);
        sb.append("( ");
        for (int i = 0; i < args.length; ++i) {
            TypeProtos.MajorType mt = args[i].getMajorType();
            FunctionGenerationHelper.appendType(mt, sb);
            if (i == 0) continue;
            sb.append(", ");
        }
        sb.append(" ) returns ");
        FunctionGenerationHelper.appendType(returnType, sb);
        throw new UnsupportedOperationException(sb.toString());
    }

    private static final void appendType(TypeProtos.MajorType mt, StringBuilder sb) {
        sb.append(mt.getMinorType().name());
        sb.append(":");
        sb.append(mt.getMode().name());
    }
}

