/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import java.util.List;
import java.util.Map;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.expr.fn.DrillSimpleFuncHolder;

public class DrillDecimalSetScaleFuncHolder
extends DrillSimpleFuncHolder {
    public DrillDecimalSetScaleFuncHolder(FunctionTemplate.FunctionScope scope, FunctionTemplate.NullHandling nullHandling, boolean isBinaryCommutative, boolean isRandom, String[] registeredNames, DrillFuncHolder.ValueReference[] parameters, DrillFuncHolder.ValueReference returnValue, DrillFuncHolder.WorkspaceReference[] workspaceVars, Map<String, String> methods, List<String> imports) {
        super(scope, nullHandling, isBinaryCommutative, isRandom, registeredNames, parameters, returnValue, workspaceVars, methods, imports);
    }

    @Override
    public TypeProtos.MajorType getReturnType(List<LogicalExpression> args) {
        TypeProtos.DataMode mode = this.returnValue.type.getMode();
        int scale = 0;
        int precision = 0;
        boolean i = false;
        if (this.nullHandling == FunctionTemplate.NullHandling.NULL_IF_NULL) {
            for (LogicalExpression e : args) {
                precision = Math.max(precision, e.getMajorType().getPrecision());
                if (e.getMajorType().getMode() != TypeProtos.DataMode.OPTIONAL) continue;
                mode = TypeProtos.DataMode.OPTIONAL;
            }
            assert (args.size() == 2 && args.get(1) instanceof ValueExpressions.IntExpression);
            scale = ((ValueExpressions.IntExpression)args.get(1)).getInt();
        }
        return TypeProtos.MajorType.newBuilder().setMinorType(this.returnValue.type.getMinorType()).setScale(scale).setPrecision(precision).setMode(mode).build();
    }
}

