/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import java.util.List;
import java.util.Map;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.util.DecimalScalePrecisionDivideFunction;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.expr.fn.DrillSimpleFuncHolder;
import org.apache.drill.exec.util.DecimalUtility;

public class DrillDecimalDivScaleFuncHolder
extends DrillSimpleFuncHolder {
    public DrillDecimalDivScaleFuncHolder(FunctionTemplate.FunctionScope scope, FunctionTemplate.NullHandling nullHandling, boolean isBinaryCommutative, boolean isRandom, String[] registeredNames, DrillFuncHolder.ValueReference[] parameters, DrillFuncHolder.ValueReference returnValue, DrillFuncHolder.WorkspaceReference[] workspaceVars, Map<String, String> methods, List<String> imports) {
        super(scope, nullHandling, isBinaryCommutative, isRandom, registeredNames, parameters, returnValue, workspaceVars, methods, imports);
    }

    @Override
    public TypeProtos.MajorType getReturnType(List<LogicalExpression> args) {
        TypeProtos.DataMode mode = this.returnValue.type.getMode();
        if (this.nullHandling == FunctionTemplate.NullHandling.NULL_IF_NULL) {
            for (LogicalExpression e : args) {
                if (e.getMajorType().getMode() != TypeProtos.DataMode.OPTIONAL) continue;
                mode = TypeProtos.DataMode.OPTIONAL;
                break;
            }
        }
        assert (args.size() == 2);
        DecimalScalePrecisionDivideFunction outputScalePrec = new DecimalScalePrecisionDivideFunction(args.get(0).getMajorType().getPrecision(), args.get(0).getMajorType().getScale(), args.get(1).getMajorType().getPrecision(), args.get(1).getMajorType().getScale());
        return TypeProtos.MajorType.newBuilder().setMinorType(DecimalUtility.getDecimalDataType(outputScalePrec.getOutputPrecision())).setScale(outputScalePrec.getOutputScale()).setPrecision(outputScalePrec.getOutputPrecision()).setMode(mode).build();
    }

    @Override
    public boolean checkPrecisionRange() {
        return true;
    }
}

