/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.fn;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JForLoop;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.DirectExpression;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.record.TypedFieldId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DrillAggFuncHolder
extends DrillFuncHolder {
    static final Logger logger = LoggerFactory.getLogger(DrillAggFuncHolder.class);
    private final String setup;
    private final String reset;
    private final String add;
    private final String output;
    private final String cleanup;

    public DrillAggFuncHolder(FunctionTemplate.FunctionScope scope, FunctionTemplate.NullHandling nullHandling, boolean isBinaryCommutative, boolean isRandom, String[] registeredNames, DrillFuncHolder.ValueReference[] parameters, DrillFuncHolder.ValueReference returnValue, DrillFuncHolder.WorkspaceReference[] workspaceVars, Map<String, String> methods, List<String> imports) {
        this(scope, nullHandling, isBinaryCommutative, isRandom, registeredNames, parameters, returnValue, workspaceVars, methods, imports, FunctionTemplate.FunctionCostCategory.getDefault());
    }

    public DrillAggFuncHolder(FunctionTemplate.FunctionScope scope, FunctionTemplate.NullHandling nullHandling, boolean isBinaryCommutative, boolean isRandom, String[] registeredNames, DrillFuncHolder.ValueReference[] parameters, DrillFuncHolder.ValueReference returnValue, DrillFuncHolder.WorkspaceReference[] workspaceVars, Map<String, String> methods, List<String> imports, FunctionTemplate.FunctionCostCategory costCategory) {
        super(scope, nullHandling, isBinaryCommutative, isRandom, registeredNames, parameters, returnValue, workspaceVars, methods, imports, costCategory);
        Preconditions.checkArgument(nullHandling == FunctionTemplate.NullHandling.INTERNAL, "An aggregation function is required to do its own null handling.");
        this.setup = methods.get("setup");
        this.reset = methods.get("reset");
        this.add = methods.get("add");
        this.output = methods.get("output");
        this.cleanup = methods.get("cleanup");
        Preconditions.checkNotNull(this.add);
        Preconditions.checkNotNull(this.output);
        Preconditions.checkNotNull(this.reset);
    }

    @Override
    public boolean isNested() {
        return true;
    }

    @Override
    public boolean isAggregating() {
        return true;
    }

    @Override
    public JVar[] renderStart(ClassGenerator<?> g, ClassGenerator.HoldingContainer[] inputVariables) {
        if (!g.getMappingSet().isHashAggMapping()) {
            JVar[] workspaceJVars = this.declareWorkspaceVariables(g);
            this.generateBody(g, ClassGenerator.BlockType.SETUP, this.setup, null, workspaceJVars, true);
            return workspaceJVars;
        }
        JVar[] workspaceJVars = this.declareWorkspaceVectors(g);
        JBlock setupBlock = g.getSetupBlock();
        JVar sizeVar = setupBlock.decl((JType)g.getModel().INT, "vectorSize", JExpr.lit((int)Integer.MAX_VALUE));
        JClass mathClass = g.getModel().ref(Math.class);
        for (int id = 0; id < this.workspaceVars.length; ++id) {
            if (this.workspaceVars[id].isInject()) continue;
            setupBlock.assign((JAssignmentTarget)sizeVar, (JExpression)mathClass.staticInvoke("min").arg((JExpression)sizeVar).arg((JExpression)g.getWorkspaceVectors().get(this.workspaceVars[id]).invoke("getValueCapacity")));
        }
        for (int i = 0; i < this.workspaceVars.length; ++i) {
            if (this.workspaceVars[i].isInject()) continue;
            setupBlock.assign((JAssignmentTarget)workspaceJVars[i], (JExpression)JExpr._new((JType)g.getHolderType(this.workspaceVars[i].majorType)));
        }
        JForLoop forLoop = setupBlock._for();
        JVar ivar = forLoop.init((JType)g.getModel().INT, "drill_internal_i", JExpr.lit((int)0));
        forLoop.test(ivar.lt((JExpression)sizeVar));
        forLoop.update(ivar.assignPlus(JExpr.lit((int)1)));
        JBlock subBlock = this.generateInitWorkspaceBlockHA(g, ClassGenerator.BlockType.SETUP, this.setup, workspaceJVars, (JExpression)ivar);
        forLoop.body().add((JStatement)subBlock);
        return workspaceJVars;
    }

    @Override
    public void renderMiddle(ClassGenerator<?> g, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars) {
        this.addProtectedBlock(g, g.getBlock(ClassGenerator.BlockType.EVAL), this.add, inputVariables, workspaceJVars, false);
    }

    @Override
    public ClassGenerator.HoldingContainer renderEnd(ClassGenerator<?> g, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars) {
        ClassGenerator.HoldingContainer out = g.declare(this.returnValue.type, false);
        JBlock sub = new JBlock();
        g.getEvalBlock().add((JStatement)sub);
        JVar internalOutput = sub.decl(8, g.getHolderType(this.returnValue.type), this.returnValue.name, (JExpression)JExpr._new((JType)g.getHolderType(this.returnValue.type)));
        this.addProtectedBlock(g, sub, this.output, null, workspaceJVars, false);
        sub.assign((JAssignmentTarget)out.getHolder(), (JExpression)internalOutput);
        if (!g.getMappingSet().isHashAggMapping()) {
            this.generateBody(g, ClassGenerator.BlockType.RESET, this.reset, null, workspaceJVars, false);
        }
        this.generateBody(g, ClassGenerator.BlockType.CLEANUP, this.cleanup, null, workspaceJVars, false);
        return out;
    }

    private JVar[] declareWorkspaceVectors(ClassGenerator<?> g) {
        JVar[] workspaceJVars = new JVar[this.workspaceVars.length];
        for (int i = 0; i < this.workspaceVars.length; ++i) {
            if (this.workspaceVars[i].isInject()) {
                workspaceJVars[i] = g.declareClassField("work", g.getModel()._ref(this.workspaceVars[i].type));
                g.getBlock(ClassGenerator.BlockType.SETUP).assign((JAssignmentTarget)workspaceJVars[i], (JExpression)g.getMappingSet().getIncoming().invoke("getContext").invoke("getManagedBuffer"));
                continue;
            }
            Preconditions.checkState(Types.isFixedWidthType(this.workspaceVars[i].majorType), String.format("Workspace variable '%s' in aggregation function '%s' is not allowed to have variable length type.", this.workspaceVars[i].name, this.registeredNames[0]));
            Preconditions.checkState(this.workspaceVars[i].majorType.getMode() == TypeProtos.DataMode.REQUIRED, String.format("Workspace variable '%s' in aggregation function '%s' is not allowed to have null or repeated type.", this.workspaceVars[i].name, this.registeredNames[0]));
            workspaceJVars[i] = g.declareClassField("work", g.getHolderType(this.workspaceVars[i].majorType));
            TypedFieldId typedFieldId = new TypedFieldId(this.workspaceVars[i].majorType, g.getWorkspaceTypes().size());
            JVar vv = g.declareVectorValueSetupAndMember(g.getMappingSet().getWorkspace(), typedFieldId);
            g.getWorkspaceTypes().add(typedFieldId);
            g.getWorkspaceVectors().put(this.workspaceVars[i], vv);
        }
        return workspaceJVars;
    }

    private JBlock generateInitWorkspaceBlockHA(ClassGenerator<?> g, ClassGenerator.BlockType bt, String body, JVar[] workspaceJVars, JExpression wsIndexVariable) {
        JBlock initBlock = new JBlock(true, true);
        if (!Strings.isNullOrEmpty(body) && !body.trim().isEmpty()) {
            JBlock sub = new JBlock(true, true);
            this.addProtectedBlockHA(g, sub, body, null, workspaceJVars, wsIndexVariable);
            initBlock.directStatement(String.format("/** start %s for function %s **/ ", bt.name(), this.registeredNames[0]));
            initBlock.add((JStatement)sub);
            initBlock.directStatement(String.format("/** end %s for function %s **/ ", bt.name(), this.registeredNames[0]));
        }
        return initBlock;
    }

    @Override
    protected void addProtectedBlock(ClassGenerator<?> g, JBlock sub, String body, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars, boolean decConstantInputOnly) {
        if (!g.getMappingSet().isHashAggMapping()) {
            super.addProtectedBlock(g, sub, body, inputVariables, workspaceJVars, decConstantInputOnly);
        } else {
            DirectExpression indexVariable = g.getMappingSet().getWorkspaceIndex();
            this.addProtectedBlockHA(g, sub, body, inputVariables, workspaceJVars, (JExpression)indexVariable);
        }
    }

    private void addProtectedBlockHA(ClassGenerator<?> g, JBlock sub, String body, ClassGenerator.HoldingContainer[] inputVariables, JVar[] workspaceJVars, JExpression wsIndexVariable) {
        if (inputVariables != null) {
            for (int i = 0; i < inputVariables.length; ++i) {
                DrillFuncHolder.ValueReference parameter = this.parameters[i];
                ClassGenerator.HoldingContainer inputVariable = inputVariables[i];
                sub.decl(inputVariable.getHolder().type(), parameter.name, (JExpression)inputVariable.getHolder());
            }
        }
        JVar[] internalVars = new JVar[workspaceJVars.length];
        for (int i = 0; i < workspaceJVars.length; ++i) {
            if (this.workspaceVars[i].isInject()) {
                internalVars[i] = sub.decl(g.getModel()._ref(this.workspaceVars[i].type), this.workspaceVars[i].name, (JExpression)workspaceJVars[i]);
                continue;
            }
            JInvocation getValueAccessor = g.getWorkspaceVectors().get(this.workspaceVars[i]).invoke("getAccessor").invoke("get");
            if (Types.usesHolderForGet(this.workspaceVars[i].majorType)) {
                sub.add((JStatement)getValueAccessor.arg(wsIndexVariable).arg((JExpression)workspaceJVars[i]));
            } else {
                sub.assign((JAssignmentTarget)workspaceJVars[i].ref("value"), (JExpression)getValueAccessor.arg(wsIndexVariable));
            }
            internalVars[i] = sub.decl(g.getHolderType(this.workspaceVars[i].majorType), this.workspaceVars[i].name, (JExpression)workspaceJVars[i]);
        }
        Preconditions.checkNotNull(body);
        sub.directStatement(body);
        JVar successVar = sub.decl((JType)JType.parse((JCodeModel)g.getModel(), (String)"boolean"), "success", JExpr.lit((boolean)false));
        for (int i = 0; i < workspaceJVars.length; ++i) {
            sub.assign((JAssignmentTarget)workspaceJVars[i], (JExpression)internalVars[i]);
            if (this.workspaceVars[i].isInject()) continue;
            JInvocation setMeth = Types.usesHolderForGet(this.workspaceVars[i].majorType) ? g.getWorkspaceVectors().get(this.workspaceVars[i]).invoke("getMutator").invoke("setSafe").arg(wsIndexVariable).arg((JExpression)workspaceJVars[i]) : g.getWorkspaceVectors().get(this.workspaceVars[i]).invoke("getMutator").invoke("setSafe").arg(wsIndexVariable).arg((JExpression)workspaceJVars[i].ref("value"));
            sub.assign((JAssignmentTarget)successVar, (JExpression)setMeth);
            JClass drillRunTimeException = g.getModel().ref(DrillRuntimeException.class);
            sub._if(successVar.eq(JExpr.lit((boolean)false)))._then()._throw((JExpression)JExpr._new((JClass)drillRunTimeException).arg(JExpr.lit((String)"setsafe() failed; cannot set holder value into the vector")));
        }
    }
}

