/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.expr.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface FunctionTemplate {
    public String name() default "";

    public String[] names() default {};

    public FunctionScope scope();

    public NullHandling nulls() default NullHandling.INTERNAL;

    public boolean isBinaryCommutative() default false;

    public boolean isRandom() default false;

    public FunctionCostCategory costCategory() default FunctionCostCategory.SIMPLE;

    public static enum FunctionCostCategory {
        SIMPLE(1),
        MEDIUM(3),
        COMPLEX(5);

        private final int value;

        private FunctionCostCategory(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static FunctionCostCategory getDefault() {
            return SIMPLE;
        }
    }

    public static enum FunctionScope {
        SIMPLE,
        POINT_AGGREGATE,
        DECIMAL_AGGREGATE,
        DECIMAL_SUM_AGGREGATE,
        HOLISTIC_AGGREGATE,
        RANGE_AGGREGATE,
        DECIMAL_MAX_SCALE,
        DECIMAL_MUL_SCALE,
        DECIMAL_CAST,
        DECIMAL_DIV_SCALE,
        DECIMAL_MOD_SCALE,
        DECIMAL_ADD_SCALE,
        DECIMAL_SET_SCALE,
        DECIMAL_ZERO_SCALE,
        SC_BOOLEAN_OPERATOR;

    }

    public static enum NullHandling {
        INTERNAL,
        NULL_IF_NULL;

    }
}

