/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.coord.local;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.coord.DistributedSemaphore;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalClusterCoordinator
extends ClusterCoordinator {
    static final Logger logger = LoggerFactory.getLogger(LocalClusterCoordinator.class);
    private volatile Map<ClusterCoordinator.RegistrationHandle, CoordinationProtos.DrillbitEndpoint> endpoints = Maps.newConcurrentMap();
    private volatile ConcurrentMap<String, DistributedSemaphore> semaphores = Maps.newConcurrentMap();

    @Override
    public void close() throws IOException {
        this.endpoints.clear();
    }

    @Override
    public void start(long millis) throws Exception {
        logger.debug("Local Cluster Coordinator started.");
    }

    @Override
    public ClusterCoordinator.RegistrationHandle register(CoordinationProtos.DrillbitEndpoint data) {
        logger.debug("Endpoint registered {}.", (Object)data);
        Handle h = new Handle();
        this.endpoints.put(h, data);
        return h;
    }

    @Override
    public void unregister(ClusterCoordinator.RegistrationHandle handle) {
        if (handle == null) {
            return;
        }
        this.endpoints.remove(handle);
    }

    @Override
    public Collection<CoordinationProtos.DrillbitEndpoint> getAvailableEndpoints() {
        return this.endpoints.values();
    }

    @Override
    public DistributedSemaphore getSemaphore(String name, int maximumLeases) {
        this.semaphores.putIfAbsent(name, new LocalSemaphore(maximumLeases));
        return (DistributedSemaphore)this.semaphores.get(name);
    }

    public class LocalSemaphore
    implements DistributedSemaphore {
        private final Semaphore inner;
        private final LocalLease lease = new LocalLease();

        public LocalSemaphore(int size) {
            this.inner = new Semaphore(size);
        }

        @Override
        public DistributedSemaphore.DistributedLease acquire(long timeout, TimeUnit unit) throws Exception {
            if (!this.inner.tryAcquire(timeout, unit)) {
                return null;
            }
            return this.lease;
        }

        private class LocalLease
        implements DistributedSemaphore.DistributedLease {
            private LocalLease() {
            }

            @Override
            public void close() throws Exception {
                LocalSemaphore.this.inner.release();
            }
        }
    }

    private class Handle
    implements ClusterCoordinator.RegistrationHandle {
        UUID id = UUID.randomUUID();

        private Handle() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Handle other = (Handle)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        private LocalClusterCoordinator getOuterType() {
            return LocalClusterCoordinator.this;
        }
    }
}

