/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile.sig;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.drill.exec.compile.sig.CodeGeneratorMethod;
import org.apache.drill.exec.compile.sig.RuntimeOverridden;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureHolder
implements Iterable<CodeGeneratorMethod> {
    static final Logger logger = LoggerFactory.getLogger(SignatureHolder.class);
    private final Class<?> signature;
    private final CodeGeneratorMethod[] methods;
    private final Map<String, Integer> methodMap;
    private final SignatureHolder[] childHolders;
    public static final CodeGeneratorMethod DRILL_INIT = new CodeGeneratorMethod("__DRILL_INIT__", Void.TYPE);

    public static SignatureHolder getHolder(Class<?> signature) {
        ArrayList<SignatureHolder> innerClasses = Lists.newArrayList();
        for (Class<?> inner : signature.getClasses()) {
            SignatureHolder h = SignatureHolder.getHolder(inner);
            if (h.childHolders.length <= 0 && h.methods.length <= 0) continue;
            innerClasses.add(h);
        }
        return new SignatureHolder(signature, innerClasses.toArray(new SignatureHolder[innerClasses.size()]));
    }

    private SignatureHolder(Class<?> signature, SignatureHolder[] childHolders) {
        Method[] reflectMethods;
        this.childHolders = childHolders;
        this.signature = signature;
        HashMap<String, Integer> newMap = Maps.newHashMap();
        ArrayList<CodeGeneratorMethod> methodHolders = Lists.newArrayList();
        for (Method m : reflectMethods = signature.getDeclaredMethods()) {
            if ((m.getModifiers() & 0x400) == 0 && m.getAnnotation(RuntimeOverridden.class) == null) continue;
            methodHolders.add(new CodeGeneratorMethod(m));
        }
        this.methods = new CodeGeneratorMethod[methodHolders.size() + 1];
        for (int i = 0; i < methodHolders.size(); ++i) {
            this.methods[i] = (CodeGeneratorMethod)methodHolders.get(i);
            Integer old = newMap.put(this.methods[i].getMethodName(), i);
            if (old == null) continue;
            throw new IllegalStateException(String.format("Attempting to add a method with name %s when there is already one method of that name in this class that is set to be runtime generated.", this.methods[i].getMethodName()));
        }
        this.methods[methodHolders.size()] = DRILL_INIT;
        newMap.put(DRILL_INIT.getMethodName(), methodHolders.size());
        this.methodMap = ImmutableMap.copyOf(newMap);
    }

    public Class<?> getSignatureClass() {
        return this.signature;
    }

    @Override
    public Iterator<CodeGeneratorMethod> iterator() {
        return Iterators.forArray(this.methods);
    }

    public int size() {
        return this.methods.length;
    }

    public SignatureHolder[] getChildHolders() {
        return this.childHolders;
    }

    public int get(String method) {
        Integer meth = this.methodMap.get(method);
        if (meth == null) {
            throw new IllegalStateException(String.format("Unknown method requested of name %s.", method));
        }
        return meth;
    }

    public String toString() {
        int maxLen = 10;
        return "SignatureHolder [methods=" + (this.methods != null ? Arrays.asList(this.methods).subList(0, Math.min(this.methods.length, 10)) : null) + "]";
    }
}

