/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import com.google.common.collect.MapMaker;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.ExpressionParsingException;
import org.apache.drill.exec.compile.AbstractClassCompiler;
import org.apache.drill.exec.compile.ClassTransformer;
import org.apache.drill.exec.compile.JDKClassCompiler;
import org.apache.drill.exec.compile.JaninoClassCompiler;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValidator;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.server.options.TypeValidators;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryClassLoader
extends URLClassLoader {
    static final Logger logger = LoggerFactory.getLogger(QueryClassLoader.class);
    public static final TypeValidators.StringValidator JAVA_COMPILER_VALIDATOR = new TypeValidators.StringValidator("exec.java_compiler", CompilerPolicy.DEFAULT.toString()){

        @Override
        public void validate(OptionValue v) throws ExpressionParsingException {
            super.validate(v);
            try {
                CompilerPolicy.valueOf(v.string_val.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ExpressionParsingException(String.format("Invalid value '%s' specified for option '%s'. Valid values are %s.", v.string_val, this.getOptionName(), Arrays.toString((Object[])CompilerPolicy.values())));
            }
        }
    };
    public static final OptionValidator JAVA_COMPILER_DEBUG = new TypeValidators.BooleanValidator("exec.java_compiler_debug", true);
    public static final OptionValidator JAVA_COMPILER_JANINO_MAXSIZE = new TypeValidators.LongValidator("exec.java_compiler_janino_maxsize", 262144L);
    private ClassCompilerSelector compilerSelector;
    private AtomicLong index = new AtomicLong(0L);
    private ConcurrentMap<String, byte[]> customClasses = new MapMaker().concurrencyLevel(4).makeMap();

    public QueryClassLoader(DrillConfig config, OptionManager sessionOptions) {
        super(new URL[0]);
        this.compilerSelector = new ClassCompilerSelector(config, sessionOptions);
    }

    public void injectByteCode(String className, byte[] classBytes) throws IOException {
        if (this.customClasses.containsKey(className)) {
            throw new IOException(String.format("The class defined {} has already been loaded.", className));
        }
        this.customClasses.put(className, classBytes);
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        byte[] ba = (byte[])this.customClasses.get(className);
        if (ba != null) {
            return this.defineClass(className, ba, 0, ba.length);
        }
        return super.findClass(className);
    }

    public byte[][] getClassByteCode(ClassTransformer.ClassNames className, String sourceCode) throws CompileException, IOException, ClassNotFoundException, ClassTransformationException {
        return this.compilerSelector.getClassByteCode(className, sourceCode);
    }

    private class ClassCompilerSelector {
        private final CompilerPolicy policy;
        private final long janinoThreshold;
        private final AbstractClassCompiler jdkClassCompiler;
        private final AbstractClassCompiler janinoClassCompiler;

        ClassCompilerSelector(DrillConfig config, OptionManager sessionOptions) {
            OptionValue value = sessionOptions.getOption("exec.java_compiler");
            this.policy = CompilerPolicy.valueOf(value != null ? value.string_val.toUpperCase() : config.getString("drill.exec.compile.compiler").toUpperCase());
            value = sessionOptions.getOption("exec.java_compiler_janino_maxsize");
            this.janinoThreshold = value != null ? value.num_val.longValue() : config.getLong("drill.exec.compile.janino_maxsize");
            value = sessionOptions.getOption("exec.java_compiler_debug");
            boolean debug = value != null ? value.bool_val.booleanValue() : config.getBoolean("drill.exec.compile.debug");
            this.janinoClassCompiler = this.policy == CompilerPolicy.JANINO || this.policy == CompilerPolicy.DEFAULT ? new JaninoClassCompiler(QueryClassLoader.this, debug) : null;
            this.jdkClassCompiler = this.policy == CompilerPolicy.JDK || this.policy == CompilerPolicy.DEFAULT ? new JDKClassCompiler(QueryClassLoader.this, debug) : null;
        }

        private byte[][] getClassByteCode(ClassTransformer.ClassNames className, String sourceCode) throws CompileException, ClassNotFoundException, ClassTransformationException, IOException {
            AbstractClassCompiler classCompiler = this.policy == CompilerPolicy.JDK || this.policy == CompilerPolicy.DEFAULT && (long)sourceCode.length() > this.janinoThreshold ? this.jdkClassCompiler : this.janinoClassCompiler;
            byte[][] bc = classCompiler.getClassByteCode(className, sourceCode);
            return bc;
        }
    }

    public static enum CompilerPolicy {
        DEFAULT,
        JDK,
        JANINO;

    }
}

