/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import com.google.common.collect.Maps;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

final class DrillJavaFileObject
extends SimpleJavaFileObject {
    private final String sourceCode;
    private final ByteArrayOutputStream outputStream;
    private Map<String, DrillJavaFileObject> outputFiles;

    public DrillJavaFileObject(String className, String sourceCode) {
        super(DrillJavaFileObject.makeURI(className), JavaFileObject.Kind.SOURCE);
        this.sourceCode = sourceCode;
        this.outputStream = null;
    }

    private DrillJavaFileObject(String name, JavaFileObject.Kind kind) {
        super(DrillJavaFileObject.makeURI(name), kind);
        this.outputStream = new ByteArrayOutputStream();
        this.sourceCode = null;
    }

    public boolean isCompiled() {
        return this.outputFiles != null;
    }

    public byte[][] getByteCode() {
        if (!this.isCompiled()) {
            return null;
        }
        int index = 0;
        byte[][] byteCode = new byte[this.outputFiles.size()][];
        for (DrillJavaFileObject outputFile : this.outputFiles.values()) {
            byteCode[index++] = outputFile.outputStream.toByteArray();
        }
        return byteCode;
    }

    public DrillJavaFileObject addOutputJavaFile(String className) {
        if (this.outputFiles == null) {
            this.outputFiles = Maps.newLinkedHashMap();
        }
        DrillJavaFileObject outputFile = new DrillJavaFileObject(className, JavaFileObject.Kind.CLASS);
        this.outputFiles.put(className, outputFile);
        return outputFile;
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return new StringReader(this.sourceCode);
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        if (this.sourceCode == null) {
            throw new UnsupportedOperationException("This instance of DrillJavaFileObject is not an input object.");
        }
        return this.sourceCode;
    }

    @Override
    public OutputStream openOutputStream() {
        if (this.outputStream == null) {
            throw new UnsupportedOperationException("This instance of DrillJavaFileObject is not an output object.");
        }
        return this.outputStream;
    }

    private static URI makeURI(String canonicalClassName) {
        int dotPos = canonicalClassName.lastIndexOf(46);
        String simpleClassName = dotPos == -1 ? canonicalClassName : canonicalClassName.substring(dotPos + 1);
        try {
            return new URI(simpleClassName + JavaFileObject.Kind.SOURCE.extension);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

