/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.compile;

import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DrillDiagnosticListener
implements DiagnosticListener<JavaFileObject> {
    static final Logger logger = LoggerFactory.getLogger(DrillDiagnosticListener.class);

    DrillDiagnosticListener() {
    }

    @Override
    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
        if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
            String message = diagnostic.toString() + " (" + diagnostic.getCode() + ")";
            logger.error(message);
            Location loc = new Location(diagnostic.getSource().toString(), (short)diagnostic.getLineNumber(), (short)diagnostic.getColumnNumber());
            throw new RuntimeException(new CompileException(message, loc));
        }
        if (logger.isTraceEnabled()) {
            logger.trace(diagnostic.toString() + " (" + diagnostic.getCode() + ")");
        }
    }
}

