/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.cache;

import com.google.protobuf.Message;
import org.apache.drill.exec.cache.DrillSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DistributedCache
extends AutoCloseable {
    public static final Logger logger = LoggerFactory.getLogger(DistributedCache.class);

    public static enum SerializationMode {
        JACKSON(Object.class),
        DRILL_SERIALIZIABLE(String.class, DrillSerializable.class),
        PROTOBUF(String.class, Message.class);

        private final Class<?>[] classes;

        private SerializationMode(Class<?> ... classes) {
            this.classes = classes;
        }

        public void checkClass(Class<?> classToCheck) {
            for (Class<?> c : this.classes) {
                if (!c.isAssignableFrom(classToCheck)) continue;
                return;
            }
            throw new UnsupportedOperationException(String.format("You are trying to serialize the class %s using the serialization mode %s.  This is not allowed.", classToCheck.getName(), this.name()));
        }
    }
}

