/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec;

import org.apache.drill.exec.server.options.OptionValidator;
import org.apache.drill.exec.server.options.TypeValidators;

public interface ExecConstants {
    public static final OptionValidator OUTPUT_FORMAT_VALIDATOR = new TypeValidators.StringValidator("store.format", "parquet");
    public static final OptionValidator PARQUET_BLOCK_SIZE_VALIDATOR = new TypeValidators.LongValidator("store.parquet.block-size", 0x20000000L);
    public static final OptionValidator PARQUET_VECTOR_FILL_THRESHOLD_VALIDATOR = new TypeValidators.PositiveLongValidator("store.parquet.vector_fill_threshold", 99L, 85L);
    public static final OptionValidator PARQUET_VECTOR_FILL_CHECK_THRESHOLD_VALIDATOR = new TypeValidators.PositiveLongValidator("store.parquet.vector_fill_check_threshold", 100L, 10L);
    public static final OptionValidator PARQUET_RECORD_READER_IMPLEMENTATION_VALIDATOR = new TypeValidators.BooleanValidator("store.parquet.use_new_reader", false);
    public static final OptionValidator JSON_READER_ALL_TEXT_MODE_VALIDATOR = new TypeValidators.BooleanValidator("store.json.all_text_mode", false);
    public static final OptionValidator FILESYSTEM_PARTITION_COLUMN_LABEL_VALIDATOR = new TypeValidators.StringValidator("drill.exec.storage.file.partition.column.label", "dir");
    public static final OptionValidator MONGO_READER_ALL_TEXT_MODE_VALIDATOR = new TypeValidators.BooleanValidator("store.mongo.all_text_mode", false);
    public static final OptionValidator SLICE_TARGET_OPTION = new TypeValidators.PositiveLongValidator("planner.slice_target", Long.MAX_VALUE, 100000L);
    public static final OptionValidator MIN_HASH_TABLE_SIZE = new TypeValidators.PositiveLongValidator("exec.min_hash_table_size", 0x40000000L, 65536L);
    public static final OptionValidator MAX_HASH_TABLE_SIZE = new TypeValidators.PositiveLongValidator("exec.max_hash_table_size", 0x40000000L, 0x40000000L);
    public static final OptionValidator MAX_WIDTH_PER_NODE = new TypeValidators.PositiveLongValidator("planner.width.max_per_node", Integer.MAX_VALUE, (long)Math.ceil((double)Runtime.getRuntime().availableProcessors() * 0.7));
    public static final OptionValidator MAX_WIDTH_GLOBAL = new TypeValidators.PositiveLongValidator("planner.width.max_per_query", Integer.MAX_VALUE, 1000L);
    public static final OptionValidator AFFINITY_FACTOR = new TypeValidators.DoubleValidator("planner.affinity_factor", 1.2);
    public static final OptionValidator ENABLE_MEMORY_ESTIMATION = new TypeValidators.BooleanValidator("planner.memory.enable_memory_estimation", false);
    public static final OptionValidator MAX_QUERY_MEMORY_PER_NODE = new TypeValidators.PowerOfTwoLongValidator("planner.memory.max_query_memory_per_node", Runtime.getRuntime().maxMemory(), 0x80000000L);
    public static final OptionValidator NON_BLOCKING_OPERATORS_MEMORY = new TypeValidators.PowerOfTwoLongValidator("planner.memory.non_blocking_operators_memory", 2048L, 64L);
    public static final OptionValidator HASH_JOIN_TABLE_FACTOR = new TypeValidators.DoubleValidator("planner.memory.hash_join_table_factor", 1.1);
    public static final OptionValidator HASH_AGG_TABLE_FACTOR = new TypeValidators.DoubleValidator("planner.memory.hash_agg_table_factor", 1.1);
    public static final OptionValidator AVERAGE_FIELD_WIDTH = new TypeValidators.PositiveLongValidator("planner.memory.average_field_width", Long.MAX_VALUE, 8L);
    public static final OptionValidator ENABLE_QUEUE = new TypeValidators.BooleanValidator("exec.queue.enable", false);
    public static final OptionValidator LARGE_QUEUE_SIZE = new TypeValidators.PositiveLongValidator("exec.queue.large", 1000L, 10L);
    public static final OptionValidator SMALL_QUEUE_SIZE = new TypeValidators.PositiveLongValidator("exec.queue.small", 100000L, 100L);
    public static final OptionValidator QUEUE_THRESHOLD_SIZE = new TypeValidators.PositiveLongValidator("exec.queue.threshold", Long.MAX_VALUE, 30000000L);
    public static final OptionValidator QUEUE_TIMEOUT = new TypeValidators.PositiveLongValidator("exec.queue.timeout_millis", Long.MAX_VALUE, 300000L);
    public static final OptionValidator ENABLE_VERBOSE_ERRORS = new TypeValidators.BooleanValidator("exec.errors.verbose", false);
}

