/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.util;

import org.apache.commons.lang3.StringEscapeUtils;

public class DrillStringUtils {
    public static String readable(long bytes) {
        int unit = 1024;
        long absBytes = Math.abs(bytes);
        if (absBytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(absBytes) / Math.log(unit));
        char pre = "KMGTPE".charAt(exp - 1);
        return String.format("%s%.1f %ciB", bytes == absBytes ? "" : "-", (double)absBytes / Math.pow(unit, exp), Character.valueOf(pre));
    }

    public static final String unescapeJava(String input) {
        return StringEscapeUtils.unescapeJava(input);
    }

    public static String toBinaryString(byte[] buf) {
        return DrillStringUtils.toBinaryString(buf, 0, buf.length);
    }

    public static String toBinaryString(byte[] buf, int strStart, int strEnd) {
        StringBuilder result = new StringBuilder();
        for (int i = strStart; i < strEnd; ++i) {
            DrillStringUtils.appendByte(result, buf[i]);
        }
        return result.toString();
    }

    private static void appendByte(StringBuilder result, byte b) {
        int ch = b & 0xFF;
        if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || " `~!@#$%^&*()-_=+[]{}|;:'\",.<>/?".indexOf(ch) >= 0) {
            result.append((char)ch);
        } else {
            result.append(String.format("\\x%02X", ch));
        }
    }
}

