/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.util;

import org.apache.drill.common.util.CoreDecimalUtility;
import org.apache.drill.common.util.DrillBaseComputeScalePrecision;

public class DecimalScalePrecisionModFunction
extends DrillBaseComputeScalePrecision {
    public DecimalScalePrecisionModFunction(int leftPrecision, int leftScale, int rightPrecision, int rightScale) {
        super(leftPrecision, leftScale, rightPrecision, rightScale);
    }

    @Override
    public void computeScalePrecision(int leftPrecision, int leftScale, int rightPrecision, int rightScale) {
        this.outputScale = Math.max(leftScale, rightScale);
        int leftIntegerDigits = leftPrecision - leftScale;
        this.outputPrecision = CoreDecimalUtility.getPrecisionRange(this.outputScale + leftIntegerDigits);
        if (this.outputScale + leftIntegerDigits > this.outputPrecision) {
            this.outputScale = this.outputPrecision - leftIntegerDigits;
        }
        this.outputPrecision = Math.max(this.outputPrecision, Math.max(leftPrecision, rightPrecision));
    }
}

