/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.graph.GraphVisitor;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.util.PathScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogicalOperatorBase
implements LogicalOperator {
    static final Logger logger = LoggerFactory.getLogger(LogicalOperatorBase.class);
    private List<LogicalOperator> children = new ArrayList<LogicalOperator>();
    private String memo;

    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public void accept(GraphVisitor<LogicalOperator> visitor) {
        if (visitor.enter(this)) {
            visitor.leave(this);
        }
    }

    @Override
    public void registerAsSubscriber(LogicalOperator operator) {
        if (operator == null) {
            throw new IllegalArgumentException("You attempted to register a null operators.");
        }
        this.children.add(operator);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [memo=" + this.memo + "]";
    }

    public static synchronized Class<?>[] getSubTypes(DrillConfig config) {
        Class<?>[] ops = PathScanner.scanForImplementationsArr(LogicalOperator.class, config.getStringList("drill.logical.operator.packages"));
        logger.debug("Adding Logical Operator sub types: {}", (Object)ops);
        return ops;
    }
}

