/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.logical;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.graph.Graph;
import org.apache.drill.common.logical.PlanProperties;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.SinkOperator;
import org.apache.drill.common.logical.data.SourceOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonPropertyOrder(value={"head", "storage", "query"})
public class LogicalPlan {
    static final Logger logger = LoggerFactory.getLogger(LogicalPlan.class);
    private final PlanProperties properties;
    private final Map<String, StoragePluginConfig> storageEngineMap;
    private final Graph<LogicalOperator, SinkOperator, SourceOperator> graph;

    @JsonCreator
    public LogicalPlan(@JsonProperty(value="head") PlanProperties head, @JsonProperty(value="storage") Map<String, StoragePluginConfig> storageEngineMap, @JsonProperty(value="query") List<LogicalOperator> operators) {
        this.storageEngineMap = storageEngineMap != null ? storageEngineMap : new HashMap();
        this.properties = head;
        this.graph = Graph.newGraph(operators, SinkOperator.class, SourceOperator.class);
    }

    public StoragePluginConfig getStorageEngineConfig(String name) {
        return this.storageEngineMap.get(name);
    }

    @JsonIgnore
    public Graph<LogicalOperator, SinkOperator, SourceOperator> getGraph() {
        return this.graph;
    }

    @JsonProperty(value="head")
    public PlanProperties getProperties() {
        return this.properties;
    }

    public String toJsonString(DrillConfig config) throws JsonProcessingException {
        return config.getMapper().writeValueAsString(this);
    }

    public String toJsonStringSafe(DrillConfig config) {
        try {
            return this.toJsonString(config);
        }
        catch (JsonProcessingException e) {
            logger.error("Failure while trying to get JSON representation of plan.", e);
            return "Unable to generate plan.";
        }
    }

    public String unparse(DrillConfig config) {
        try {
            return config.getMapper().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

