/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import com.google.common.collect.Iterators;
import java.util.GregorianCalendar;
import java.util.Iterator;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.LogicalExpressionBase;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;

public class ValueExpressions {
    public static LogicalExpression getBigInt(long l) {
        return new LongExpression(l);
    }

    public static LogicalExpression getInt(int i) {
        return new IntExpression(i, ExpressionPosition.UNKNOWN);
    }

    public static LogicalExpression getFloat8(double d) {
        return new DoubleExpression(d, ExpressionPosition.UNKNOWN);
    }

    public static LogicalExpression getFloat4(float f) {
        return new DoubleExpression(f, ExpressionPosition.UNKNOWN);
    }

    public static LogicalExpression getBit(boolean b) {
        return new BooleanExpression(Boolean.toString(b), ExpressionPosition.UNKNOWN);
    }

    public static LogicalExpression getChar(String s) {
        return new QuotedString(s, ExpressionPosition.UNKNOWN);
    }

    public static LogicalExpression getDate(GregorianCalendar date) {
        return new DateExpression(date.getTimeInMillis());
    }

    public static LogicalExpression getTime(GregorianCalendar time) {
        int millis = time.get(11) * 60 * 60 * 1000 + time.get(12) * 60 * 1000 + time.get(13) * 1000 + time.get(14);
        return new TimeExpression(millis);
    }

    public static LogicalExpression getTimeStamp(GregorianCalendar date) {
        return new TimeStampExpression(date.getTimeInMillis());
    }

    public static LogicalExpression getIntervalYear(int months) {
        return new IntervalYearExpression(months);
    }

    public static LogicalExpression getIntervalDay(long intervalInMillis) {
        return new IntervalDayExpression(intervalInMillis);
    }

    public static LogicalExpression getNumericExpression(String sign, String s, ExpressionPosition ep) {
        String numStr = sign == null ? s : sign + s;
        try {
            int a = Integer.parseInt(numStr);
            return new IntExpression(a, ep);
        }
        catch (Exception a) {
            try {
                long l = Long.parseLong(numStr);
                return new LongExpression(l, ep);
            }
            catch (Exception l) {
                try {
                    double d = Double.parseDouble(numStr);
                    return new DoubleExpression(d, ep);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(String.format("Unable to parse string %s as integer or floating point number.", numStr));
                }
            }
        }
    }

    public static class QuotedString
    extends ValueExpression<String> {
        private static final TypeProtos.MajorType QUOTED_STRING_CONSTANT = Types.required(TypeProtos.MinorType.VARCHAR);

        public QuotedString(String value, ExpressionPosition pos) {
            super(value, pos);
        }

        @Override
        protected String parseValue(String s) {
            return s;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return QUOTED_STRING_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitQuotedStringConstant(this, value);
        }
    }

    public static class IntervalDayExpression
    extends LogicalExpressionBase {
        private static final TypeProtos.MajorType INTERVALDAY_CONSTANT = Types.required(TypeProtos.MinorType.INTERVALDAY);
        private int days;
        private int millis;

        public IntervalDayExpression(long intervalInMillis) {
            this((int)(intervalInMillis / 86400000L), (int)(intervalInMillis % 86400000L), ExpressionPosition.UNKNOWN);
        }

        public IntervalDayExpression(int days, int millis, ExpressionPosition pos) {
            super(pos);
            this.days = days;
            this.millis = millis;
        }

        public int getIntervalDay() {
            return this.days;
        }

        public int getIntervalMillis() {
            return this.millis;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return INTERVALDAY_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitIntervalDayConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public int getSelfCost() {
            return 0;
        }

        @Override
        public int getCumulativeCost() {
            return 0;
        }
    }

    public static class IntervalYearExpression
    extends LogicalExpressionBase {
        private static final TypeProtos.MajorType INTERVALYEAR_CONSTANT = Types.required(TypeProtos.MinorType.INTERVALYEAR);
        private int months;

        public IntervalYearExpression(int months) {
            this(months, ExpressionPosition.UNKNOWN);
        }

        public IntervalYearExpression(int months, ExpressionPosition pos) {
            super(pos);
            this.months = months;
        }

        public int getIntervalYear() {
            return this.months;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return INTERVALYEAR_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitIntervalYearConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public int getSelfCost() {
            return 0;
        }

        @Override
        public int getCumulativeCost() {
            return 0;
        }
    }

    public static class TimeStampExpression
    extends LogicalExpressionBase {
        private static final TypeProtos.MajorType TIMESTAMP_CONSTANT = Types.required(TypeProtos.MinorType.TIMESTAMP);
        private long timeInMillis;

        public TimeStampExpression(long timeInMillis) {
            this(timeInMillis, ExpressionPosition.UNKNOWN);
        }

        public TimeStampExpression(long timeInMillis, ExpressionPosition pos) {
            super(pos);
            this.timeInMillis = timeInMillis;
        }

        public long getTimeStamp() {
            return this.timeInMillis;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return TIMESTAMP_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitTimeStampConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public int getSelfCost() {
            return 0;
        }

        @Override
        public int getCumulativeCost() {
            return 0;
        }
    }

    public static class TimeExpression
    extends LogicalExpressionBase {
        private static final TypeProtos.MajorType TIME_CONSTANT = Types.required(TypeProtos.MinorType.TIME);
        private int timeInMillis;

        public TimeExpression(int timeInMillis) {
            this(timeInMillis, ExpressionPosition.UNKNOWN);
        }

        public TimeExpression(int timeInMillis, ExpressionPosition pos) {
            super(pos);
            this.timeInMillis = timeInMillis;
        }

        public int getTime() {
            return this.timeInMillis;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return TIME_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitTimeConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public int getSelfCost() {
            return 0;
        }

        @Override
        public int getCumulativeCost() {
            return 0;
        }
    }

    public static class DateExpression
    extends LogicalExpressionBase {
        private static final TypeProtos.MajorType DATE_CONSTANT = Types.required(TypeProtos.MinorType.DATE);
        private long dateInMillis;

        public DateExpression(long l) {
            this(l, ExpressionPosition.UNKNOWN);
        }

        public DateExpression(long dateInMillis, ExpressionPosition pos) {
            super(pos);
            this.dateInMillis = dateInMillis;
        }

        public long getDate() {
            return this.dateInMillis;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return DATE_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitDateConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public int getSelfCost() {
            return 0;
        }

        @Override
        public int getCumulativeCost() {
            return 0;
        }
    }

    public static class LongExpression
    extends LogicalExpressionBase {
        private static final TypeProtos.MajorType LONG_CONSTANT = Types.required(TypeProtos.MinorType.BIGINT);
        private long l;

        public LongExpression(long l) {
            this(l, ExpressionPosition.UNKNOWN);
        }

        public LongExpression(long l, ExpressionPosition pos) {
            super(pos);
            this.l = l;
        }

        public long getLong() {
            return this.l;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return LONG_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitLongConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public int getSelfCost() {
            return 0;
        }

        @Override
        public int getCumulativeCost() {
            return 0;
        }
    }

    public static class DoubleExpression
    extends LogicalExpressionBase {
        private double d;
        private static final TypeProtos.MajorType DOUBLE_CONSTANT = Types.required(TypeProtos.MinorType.FLOAT8);

        public DoubleExpression(double d, ExpressionPosition pos) {
            super(pos);
            this.d = d;
        }

        public double getDouble() {
            return this.d;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return DOUBLE_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitDoubleConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public int getSelfCost() {
            return 0;
        }

        @Override
        public int getCumulativeCost() {
            return 0;
        }
    }

    public static class IntExpression
    extends LogicalExpressionBase {
        private static final TypeProtos.MajorType INT_CONSTANT = Types.required(TypeProtos.MinorType.INT);
        private int i;

        public IntExpression(int i, ExpressionPosition pos) {
            super(pos);
            this.i = i;
        }

        public int getInt() {
            return this.i;
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return INT_CONSTANT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitIntConstant(this, value);
        }

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public int getSelfCost() {
            return 0;
        }

        @Override
        public int getCumulativeCost() {
            return 0;
        }
    }

    public static class BooleanExpression
    extends ValueExpression<Boolean> {
        public BooleanExpression(String value, ExpressionPosition pos) {
            super(value, pos);
        }

        @Override
        protected Boolean parseValue(String s) {
            return Boolean.parseBoolean(s);
        }

        @Override
        public TypeProtos.MajorType getMajorType() {
            return Types.REQUIRED_BIT;
        }

        @Override
        public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
            return visitor.visitBooleanConstant(this, value);
        }

        public boolean getBoolean() {
            return (Boolean)this.value;
        }
    }

    protected static abstract class ValueExpression<V>
    extends LogicalExpressionBase {
        public final Object value;

        protected ValueExpression(String value, ExpressionPosition pos) {
            super(pos);
            this.value = this.parseValue(value);
        }

        protected abstract V parseValue(String var1);

        @Override
        public Iterator<LogicalExpression> iterator() {
            return Iterators.emptyIterator();
        }

        @Override
        public int getSelfCost() {
            return 0;
        }

        @Override
        public int getCumulativeCost() {
            return 0;
        }
    }
}

