/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.common.expression;

import java.util.List;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.visitors.ExprVisitor;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;

public class BooleanOperator
extends FunctionCall {
    public BooleanOperator(String name, List<LogicalExpression> args, ExpressionPosition pos) {
        super(name, args, pos);
    }

    @Override
    public <T, V, E extends Exception> T accept(ExprVisitor<T, V, E> visitor, V value) throws E {
        return visitor.visitBooleanOperator(this, value);
    }

    @Override
    public TypeProtos.MajorType getMajorType() {
        for (LogicalExpression e : this.args) {
            if (e.getMajorType().getMode() != TypeProtos.DataMode.OPTIONAL) continue;
            return Types.OPTIONAL_BIT;
        }
        return Types.REQUIRED_BIT;
    }

    @Override
    public int getSelfCost() {
        return 0;
    }

    @Override
    public int getCumulativeCost() {
        int cost = 0;
        int i = 0;
        for (LogicalExpression e : this) {
            cost += e.getCumulativeCost();
            ++i;
        }
        return cost / i;
    }
}

