/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery;

import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.x.discovery.LocalIpFilter;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceType;
import org.apache.curator.x.discovery.UriSpec;

public class ServiceInstanceBuilder<T> {
    private Object payload;
    private String name;
    private String address;
    private Integer port;
    private Integer sslPort;
    private String id;
    private long registrationTimeUTC;
    private ServiceType serviceType = ServiceType.DYNAMIC;
    private UriSpec uriSpec;
    private static final AtomicReference<LocalIpFilter> localIpFilter = new AtomicReference<1>(new LocalIpFilter(){

        @Override
        public boolean use(NetworkInterface nif, InetAddress adr) throws SocketException {
            return adr != null && !adr.isLoopbackAddress() && (nif.isPointToPoint() || !adr.isLinkLocalAddress());
        }
    });

    ServiceInstanceBuilder() {
    }

    public ServiceInstance<T> build() {
        return new ServiceInstance<Object>(this.name, this.id, this.address, this.port, this.sslPort, this.payload, this.registrationTimeUTC, this.serviceType, this.uriSpec);
    }

    public ServiceInstanceBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public ServiceInstanceBuilder<T> address(String address) {
        this.address = address;
        return this;
    }

    public ServiceInstanceBuilder<T> id(String id) {
        this.id = id;
        return this;
    }

    public ServiceInstanceBuilder<T> port(int port) {
        this.port = port;
        return this;
    }

    public ServiceInstanceBuilder<T> payload(T payload) {
        this.payload = payload;
        return this;
    }

    public ServiceInstanceBuilder<T> registrationTimeUTC(long registrationTimeUTC) {
        this.registrationTimeUTC = registrationTimeUTC;
        return this;
    }

    public static Collection<InetAddress> getAllLocalIPs() throws SocketException {
        ArrayList<InetAddress> listAdr = Lists.newArrayList();
        Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
        if (nifs == null) {
            return listAdr;
        }
        while (nifs.hasMoreElements()) {
            NetworkInterface nif = nifs.nextElement();
            Enumeration<InetAddress> adrs = nif.getInetAddresses();
            while (adrs.hasMoreElements()) {
                InetAddress adr = adrs.nextElement();
                if (!localIpFilter.get().use(nif, adr)) continue;
                listAdr.add(adr);
            }
        }
        return listAdr;
    }
}

