/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseableExecutorService
implements Closeable {
    private final Logger log = LoggerFactory.getLogger(CloseableExecutorService.class);
    private final Set<Future<?>> futures = Sets.newSetFromMap(Maps.newConcurrentMap());
    private final ExecutorService executorService;
    private final boolean shutdownOnClose;
    protected final AtomicBoolean isOpen = new AtomicBoolean(true);

    public CloseableExecutorService(ExecutorService executorService, boolean shutdownOnClose) {
        this.executorService = executorService;
        this.shutdownOnClose = shutdownOnClose;
    }

    public boolean isShutdown() {
        return !this.isOpen.get();
    }

    @Override
    public void close() {
        this.isOpen.set(false);
        Iterator<Future<?>> iterator = this.futures.iterator();
        while (iterator.hasNext()) {
            Future<?> future = iterator.next();
            iterator.remove();
            if (future.isDone() || future.isCancelled() || future.cancel(true)) continue;
            this.log.warn("Could not cancel " + future);
        }
        if (this.shutdownOnClose) {
            this.executorService.shutdownNow();
        }
    }

    public Future<?> submit(Runnable task) {
        Preconditions.checkState(this.isOpen.get(), "CloseableExecutorService is closed");
        InternalFutureTask<Object> futureTask = new InternalFutureTask<Object>(new FutureTask<Object>(task, null));
        this.executorService.execute(futureTask);
        return futureTask;
    }

    protected class InternalFutureTask<T>
    extends FutureTask<T> {
        private final RunnableFuture<T> task;

        InternalFutureTask(RunnableFuture<T> task) {
            super(task, null);
            this.task = task;
            CloseableExecutorService.this.futures.add(task);
        }

        @Override
        protected void done() {
            CloseableExecutorService.this.futures.remove(this.task);
        }
    }
}

