/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.queue;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.listen.ListenerContainer;
import org.apache.curator.framework.recipes.queue.ChildrenCache;
import org.apache.curator.framework.recipes.queue.QueueBase;
import org.apache.curator.utils.CloseableUtils;

public class DistributedQueue<T>
implements QueueBase<T> {
    private final ExecutorService service;
    private final AtomicReference<State> state;
    private final ListenerContainer<Object<T>> putListenerContainer;
    private final int finalFlushMs;
    private final ChildrenCache childrenCache;
    private final AtomicInteger putCount;

    @Override
    public void close() throws IOException {
        if (this.state.compareAndSet(State.STARTED, State.STOPPED)) {
            if (this.finalFlushMs > 0) {
                try {
                    this.flushPuts(this.finalFlushMs, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            CloseableUtils.closeQuietly(this.childrenCache);
            this.putListenerContainer.clear();
            this.service.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushPuts(long waitTime, TimeUnit timeUnit) throws InterruptedException {
        long msWaitRemaining = TimeUnit.MILLISECONDS.convert(waitTime, timeUnit);
        AtomicInteger atomicInteger = this.putCount;
        synchronized (atomicInteger) {
            while (this.putCount.get() > 0) {
                if (msWaitRemaining <= 0L) {
                    return false;
                }
                long startMs = System.currentTimeMillis();
                this.putCount.wait(msWaitRemaining);
                long elapsedMs = System.currentTimeMillis() - startMs;
                msWaitRemaining -= elapsedMs;
            }
        }
        return true;
    }

    private static enum ProcessMessageBytesCode {
        NORMAL,
        REQUEUE;

    }

    protected static enum ProcessType {
        NORMAL,
        REMOVE;

    }

    private static enum State {
        LATENT,
        STARTED,
        STOPPED;

    }
}

