/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.locks;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.utils.CloseableScheduledExecutorService;

public class Reaper
implements Closeable {
    private final CloseableScheduledExecutorService executor;
    private final AtomicReference<State> state;
    private final LeaderLatch leaderLatch;
    static final int DEFAULT_REAPING_THRESHOLD_MS = (int)TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);

    @Override
    public void close() throws IOException {
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            this.executor.close();
            if (this.leaderLatch != null) {
                this.leaderLatch.close();
            }
        }
    }

    public static enum Mode {
        REAP_INDEFINITELY,
        REAP_UNTIL_DELETE,
        REAP_UNTIL_GONE;

    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

