/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.leader;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.utils.CloseableExecutorService;
import org.apache.curator.utils.ThreadUtils;

public class LeaderSelector
implements Closeable {
    private final CuratorFramework client;
    private final LeaderSelectorListener listener;
    private final CloseableExecutorService executorService;
    private final AtomicReference<State> state;
    private final AtomicReference<Future<?>> ourTask;
    private static final ThreadFactory defaultThreadFactory = ThreadUtils.newThreadFactory("LeaderSelector");

    @Override
    public synchronized void close() {
        Preconditions.checkState(this.state.compareAndSet(State.STARTED, State.CLOSED), "Already closed or has not been started");
        this.client.getConnectionStateListenable().removeListener(this.listener);
        this.executorService.close();
        this.ourTask.set(null);
    }

    private static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

