/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.leader;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.listen.ListenerContainer;
import org.apache.curator.framework.recipes.leader.LeaderLatchListener;
import org.apache.curator.framework.recipes.locks.LockInternalsSorter;
import org.apache.curator.framework.recipes.locks.StandardLockInternalsDriver;
import org.apache.curator.framework.state.ConnectionStateListener;

public class LeaderLatch
implements Closeable {
    private final CuratorFramework client;
    private final AtomicReference<State> state;
    private final AtomicBoolean hasLeadership;
    private final AtomicReference<String> ourPath;
    private final ListenerContainer<LeaderLatchListener> listeners;
    private final CloseMode closeMode;
    private final ConnectionStateListener listener;
    private static final LockInternalsSorter sorter = new LockInternalsSorter(){

        @Override
        public String fixForSorting(String str, String lockName) {
            return StandardLockInternalsDriver.standardFixForSorting(str, lockName);
        }
    };

    @Override
    public void close() throws IOException {
        this.close(this.closeMode);
    }

    public void close(CloseMode closeMode) throws IOException {
        Preconditions.checkState(this.state.compareAndSet(State.STARTED, State.CLOSED), "Already closed or has not been started");
        Preconditions.checkNotNull(closeMode, "closeMode cannot be null");
        try {
            this.setNode(null);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.client.getConnectionStateListenable().removeListener(this.listener);
            switch (closeMode) {
                case NOTIFY_LEADER: {
                    this.setLeadership(false);
                    this.listeners.clear();
                    break;
                }
                default: {
                    this.listeners.clear();
                    this.setLeadership(false);
                }
            }
        }
    }

    private synchronized void setLeadership(boolean newValue) {
        boolean oldValue = this.hasLeadership.getAndSet(newValue);
        if (oldValue && !newValue) {
            this.listeners.forEach(new Function<LeaderLatchListener, Void>(){

                public Void apply(LeaderLatchListener listener) {
                    listener.notLeader();
                    return null;
                }
            });
        } else if (!oldValue && newValue) {
            this.listeners.forEach(new Function<LeaderLatchListener, Void>(){

                public Void apply(LeaderLatchListener input) {
                    input.isLeader();
                    return null;
                }
            });
        }
        this.notifyAll();
    }

    private void setNode(String newValue) throws Exception {
        String oldPath = this.ourPath.getAndSet(newValue);
        if (oldPath != null) {
            ((Pathable)this.client.delete().guaranteed().inBackground()).forPath(oldPath);
        }
    }

    public static enum CloseMode {
        SILENT,
        NOTIFY_LEADER;

    }

    public static enum State {
        LATENT,
        STARTED,
        CLOSED;

    }
}

