/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import com.google.common.cache.CacheBuilder;
import java.io.Closeable;
import java.util.concurrent.ConcurrentMap;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.NamespaceWatcher;
import org.apache.zookeeper.Watcher;

class NamespaceWatcherMap
implements Closeable {
    private final ConcurrentMap<Object, NamespaceWatcher> map = CacheBuilder.newBuilder().weakValues().build().asMap();
    private final CuratorFrameworkImpl client;

    NamespaceWatcherMap(CuratorFrameworkImpl client) {
        this.client = client;
    }

    @Override
    public void close() {
        this.map.clear();
    }

    NamespaceWatcher remove(Object key) {
        return (NamespaceWatcher)this.map.remove(key);
    }

    NamespaceWatcher getNamespaceWatcher(Watcher watcher) {
        return this.get(watcher, new NamespaceWatcher(this.client, watcher));
    }

    NamespaceWatcher getNamespaceWatcher(CuratorWatcher watcher) {
        return this.get(watcher, new NamespaceWatcher(this.client, watcher));
    }

    private NamespaceWatcher get(Object watcher, NamespaceWatcher newNamespaceWatcher) {
        NamespaceWatcher existingNamespaceWatcher = this.map.putIfAbsent(watcher, newNamespaceWatcher);
        return existingNamespaceWatcher != null ? existingNamespaceWatcher : newNamespaceWatcher;
    }
}

