/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.imps;

import java.util.concurrent.Callable;
import org.apache.curator.RetryLoop;
import org.apache.curator.TimeTrace;
import org.apache.curator.framework.api.BackgroundCallback;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.api.CuratorEventType;
import org.apache.curator.framework.api.DeleteBuilder;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.imps.BackgroundOperation;
import org.apache.curator.framework.imps.Backgrounding;
import org.apache.curator.framework.imps.CuratorEventImpl;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.OperationAndData;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;

class DeleteBuilderImpl
implements DeleteBuilder,
BackgroundOperation<String> {
    private final CuratorFrameworkImpl client;
    private int version;
    private Backgrounding backgrounding;
    private boolean deletingChildrenIfNeeded;
    private boolean guaranteed;

    DeleteBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.version = -1;
        this.backgrounding = new Backgrounding();
        this.deletingChildrenIfNeeded = false;
        this.guaranteed = false;
    }

    @Override
    public ChildrenDeletable guaranteed() {
        this.guaranteed = true;
        return this;
    }

    @Override
    public Pathable<Void> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public Pathable<Void> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        final TimeTrace trace = this.client.getZookeeperClient().startTracer("DeleteBuilderImpl-Background");
        this.client.getZooKeeper().delete((String)operationAndData.getData(), this.version, new AsyncCallback.VoidCallback(){

            @Override
            public void processResult(int rc, String path, Object ctx) {
                trace.commit();
                if (rc == KeeperException.Code.NOTEMPTY.intValue() && DeleteBuilderImpl.this.deletingChildrenIfNeeded) {
                    DeleteBuilderImpl.this.backgroundDeleteChildrenThenNode(operationAndData);
                } else {
                    CuratorEventImpl event = new CuratorEventImpl(DeleteBuilderImpl.this.client, CuratorEventType.DELETE, rc, path, null, ctx, null, null, null, null, null);
                    DeleteBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
                }
            }
        }, this.backgrounding.getContext());
    }

    private void backgroundDeleteChildrenThenNode(final OperationAndData<String> mainOperationAndData) {
        BackgroundOperation<String> operation = new BackgroundOperation<String>(){

            @Override
            public void performBackgroundOperation(OperationAndData<String> dummy) throws Exception {
                try {
                    ZKPaths.deleteChildren(DeleteBuilderImpl.this.client.getZooKeeper(), (String)mainOperationAndData.getData(), false);
                }
                catch (KeeperException keeperException) {
                    // empty catch block
                }
                DeleteBuilderImpl.this.client.queueOperation(mainOperationAndData);
            }
        };
        OperationAndData<Object> parentOperation = new OperationAndData<Object>(operation, mainOperationAndData.getData(), null, null, this.backgrounding.getContext());
        this.client.queueOperation(parentOperation);
    }

    @Override
    public Void forPath(String path) throws Exception {
        final String unfixedPath = path;
        path = this.client.fixForNamespace(path);
        if (this.backgrounding.inBackground()) {
            OperationAndData.ErrorCallback<String> errorCallback = null;
            if (this.guaranteed) {
                errorCallback = new OperationAndData.ErrorCallback<String>(){

                    @Override
                    public void retriesExhausted(OperationAndData<String> operationAndData) {
                        DeleteBuilderImpl.this.client.getFailedDeleteManager().addFailedDelete(unfixedPath);
                    }
                };
            }
            this.client.processBackgroundOperation(new OperationAndData<String>(this, path, this.backgrounding.getCallback(), errorCallback, this.backgrounding.getContext()), null);
        } else {
            this.pathInForeground(path, unfixedPath);
        }
        return null;
    }

    private void pathInForeground(final String path, String unfixedPath) throws Exception {
        TimeTrace trace = this.client.getZookeeperClient().startTracer("DeleteBuilderImpl-Foreground");
        try {
            RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        DeleteBuilderImpl.this.client.getZooKeeper().delete(path, DeleteBuilderImpl.this.version);
                    }
                    catch (KeeperException.NotEmptyException e) {
                        if (DeleteBuilderImpl.this.deletingChildrenIfNeeded) {
                            ZKPaths.deleteChildren(DeleteBuilderImpl.this.client.getZooKeeper(), path, true);
                        }
                        throw e;
                    }
                    return null;
                }
            });
        }
        catch (KeeperException.NodeExistsException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.guaranteed) {
                this.client.getFailedDeleteManager().addFailedDelete(unfixedPath);
            }
            throw e;
        }
        trace.commit();
    }
}

